variable "kaas_vsphere_server_ip" {
  description = "URL of vSphere server"
  default = "vcenter-67.ssl.mirantis.net"
}

variable "kaas_vsphere_server_port" {
  description = "URL of vSphere server"
  default = ""
}

variable "kaas_vsphere_capi_provider_password" {
  description = "Username for connecting to vSphere"
}

variable "kaas_vsphere_capi_provider_username" {
  description = "Password for vSphere connection"
}

variable "kaas_vsphere_cloud_provider_username" {
  description = "Username for vSphere connection"
  default = "user"
}

variable "kaas_vsphere_cloud_provider_password" {
  description = "Password for vSphere connection"
  default = "password"
}

variable "kaas_vsphere_datacenter_name" {
  default = "MIRANTIS"
}

variable "kaas_vsphere_resource_pool_path" {
  default = "/MIRANTIS/host/vCluster-BMTeam/Resources/SI-TestsResPool"
}

variable "kaas_vsphere_datastorecluster_path" {
  default = "/MIRANTIS/datastore/DatastoreCluster-BMTeam"
}

variable "kaas_vsphere_network_path" {
  default = "/MIRANTIS/network/VMWare_SI_VMs_DHCP"
}

variable "kaas_vsphere_os_template_path" {
  default = ""
}

variable "managers_count" {
  description = ""
  default = 3
}

variable "workers_count" {
  description = ""
  default = 3
}

variable "kaas_vsphere_machines_folder" {
  description = ""
  default = "SI-Tests-VMs/machines"
}


variable "mke_admin_username" {
  description = "Desired username for the MKE admin account"
  default     = "admin"
}

variable "mke_admin_password" {
  description = "Desired password for the MKE admin account"
  default = "devpassword"
}

variable "mke_lb_dns_name" {
  description = "DNS name of the MKE load balancer"
  default = ""
}

variable "kaas_vsphere_ipam_range" {
  description = ""
  default = "192.168.1.2-192.168.1.100"
}

variable "kaas_vsphere_dns" {
  description = "Nameserver for ipam for child cluster"
  default = "172.18.176.6"
}

variable "kaas_vsphere_network_gateway" {
  description = "Gateway host for IPAM"
  default = ""
}

variable "kaas_vsphere_ipam_enabled" {
  type        = bool
  description = "Use IPAM to assign ip during deployment instead of dhcp"
  default     = false
}

variable "cluster_name" {
  description = ""
}

variable "mke_version" {
  description = ""
  default = "3.5.7"
}

variable "mke_repo" {
  description = ""
  default = "docker.io/mirantis"
}

variable "mcr_version" {
  description = ""
  default = "20.10.13"
}

variable "mcr_repo" {
  description = ""
  default = "https://repos.mirantis.com"
}

variable "mcr_channel" {
  description = ""
  default = "stable"
}

variable "msr_count" {
  default = 0
}

variable "ssh_username" {
  description = ""
  default = "ubuntu"
}

variable "kaas_ci_rhel_licenses_rpm_url" {
  description = ""
  default = "test"
}

variable "kaas_vsphere_datastore_name" {
  description = ""
  default = "iscsi-storage-si"
}

variable "kaas_vsphere_numcpu" {
  description = ""
  default = 8
}

variable "kaas_vsphere_machine_ram" {
  description = ""
  default = 16384
}

variable "kaas_vsphere_machine_disk" {
  description = ""
  default = 120
}
