#    Copyright 2022 Mirantis, Inc.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations

from si_tests.clients.k8s import base


class V1TFImagePreCaching(base.BaseModel):
    pass


class V1TFImagePreCachingList(base.BaseModelList):
    pass


class TFImagePreCaching(base.K8sNamespacedResource):
    resource_type = 'tfimageprecaching'
    model = V1TFImagePreCaching


class TFImagePreCachingManager(base.K8sBaseManager):
    model = V1TFImagePreCachingList
    resource_class = TFImagePreCaching
    resource_group = 'image-pre-caching.tf.mirantis.com'
    resource_version = 'v1alpha1'
    resource_plural = 'tfimageprecachings'


class V2TFImagePreCaching(base.BaseModel):
    pass


class V2TFImagePreCachingList(base.BaseModelList):
    pass


class TFImagePreCachingV2(base.K8sNamespacedResource):
    resource_type = 'tfimageprecaching'
    model = V2TFImagePreCaching


class TFImagePreCachingManagerV2(base.K8sBaseManager):
    model = V2TFImagePreCachingList
    resource_class = TFImagePreCachingV2
    resource_group = 'tf.mirantis.com'
    resource_version = 'v2'
    resource_plural = 'tfimageprecachings'
