from si_tests import settings, logger
from si_tests.managers import bootstrap_manager
from si_tests.managers import ntp_manager

LOG = logger.logger


def test_install_ntp_on_seed_node():
    """Install NTP server on seed node"""

    bootstrap = bootstrap_manager.BootstrapManager.get_si_config_bootstrap_manager()
    ntp = ntp_manager.NTPManager(bootstrap_manager=bootstrap)
    LOG.info(f"Install and configure NTP server on the seed node IP {ntp.seed_node_ip}")
    ntp_pools = settings.SEED_NTP_POOLS
    use_local_time = not ntp_pools
    ntp.install_ntp(ntp_pools=ntp_pools, use_local_time=use_local_time)
