variable "cluster_name" {}

variable "mke_version" {
  type    = string
  default = "3.6.3"
}

variable "mcr_version" {
  type    = string
  default = "20.10.12"
}

variable "mcr_repo" {
  type        = string
  description = "MCR repository URL"
  default     = "https://repos.mirantis.com"
}

variable "mcr_channel" {
  type        = string
  description = "MCR channel to use"
  default     = "stable"
}

variable "msr_count" {
  default = 0
}

variable "mke_repo" {
  type    = string
  default = "docker.io/mirantis"
}

variable "provider_config_file_path" {
  type        = string
  default     = "./cloud_provider.conf"
  description = "Path to store cloud.conf"
}

variable "http_proxy" {
  type    = string
  default = ""
}

variable "https_proxy" {
  type    = string
  default = ""
}

variable dns_ip_list {
  type    = list(string)
  default = []
}

variable "docker_default_address_pool" {
  type    = string
  default = "10.0.201.1/24"
}

variable "external_network_name" {}
variable "external_network_id" {}

variable "region" {
  default = "RegionOne"
}

variable "mke_username" {
  default = "admin"
}

variable "docker_int_net" {
  type        = string
  default     = "10.0.200.1/24"
  description = "This is the internal docker network CIDR"
}

variable "master_count" {
  default = 1
}

variable "worker_count" {
  default = 3
}

variable "master_image_name" {}

variable "worker_image_name" {}

variable "master_flavor" {}

variable "worker_flavor" {}

variable "master_volume_size" {
  default = 100
}

variable "worker_volume_size" {
  default = 100
}

variable "ssh_username" {
  type        = string
  description = "ssh username"
}
