#!/usr/bin/env bash


function _KILL_JOBS() {
  for pid in $(jobs -r -p); do
    if [[ $(ps -p $pid) && $? -eq 0 ]]; then
      kill $pid
    fi
  done
}

function _INT_TERM() {
  echo ""
  echo ["EXIT"]

  _KILL_JOBS

  exit 1;
}

trap _INT_TERM INT TERM
trap _KILL_JOBS EXIT


function set_power(){
  local ACTION=${1:-'status'}
  local TARGET=${2:-'all'}

  local DEFAULT_IPMI="172.18.168.10"
  local DEFAULT_LOGIN="admin"
  local DEFAULT_PASSWORD="password"

  # name ipmi_ip ipmi_port ipmi_login ipmi_password
  local MGMT=(
    'vm-456-0' $DEFAULT_IPMI '50000' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-456-1' $DEFAULT_IPMI '50001' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-456-2' $DEFAULT_IPMI '50002' $DEFAULT_LOGIN $DEFAULT_PASSWORD
  )

  local CHILD=(
    'vm-456-3' $DEFAULT_IPMI '50003' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-456-4' $DEFAULT_IPMI '50004' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-456-5' $DEFAULT_IPMI '50005' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-456-6' $DEFAULT_IPMI '50006' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-456-7' $DEFAULT_IPMI '50007' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-456-8' $DEFAULT_IPMI '50008' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-456-9' $DEFAULT_IPMI '50009' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-456-10' $DEFAULT_IPMI '50010' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-456-11' $DEFAULT_IPMI '50011' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-456-12' $DEFAULT_IPMI '50012' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-456-13' $DEFAULT_IPMI '50013' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-456-14' $DEFAULT_IPMI '50014' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-456-15' $DEFAULT_IPMI '50015' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-456-16' $DEFAULT_IPMI '50016' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-456-17' $DEFAULT_IPMI '50017' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-456-18' $DEFAULT_IPMI '50018' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-456-19' $DEFAULT_IPMI '50019' $DEFAULT_LOGIN $DEFAULT_PASSWORD
  )

  case $TARGET in
    mgmt) ARR=( ${MGMT[@]} );
      ;;
    child) ARR=( ${CHILD[@]} );
      ;;
    all) ARR=( ${MGMT[@]} ${CHILD[@]} );
      ;;
  esac

  for i in $(seq 0 5 $(expr ${#ARR[@]} - 1)); do
    echo "node: ${ARR[i]}"
    CMD=(ipmitool -I lanplus -H ${ARR[i+1]} -p ${ARR[i+2]} -U ${ARR[i+3]} -P ${ARR[i+4]} chassis power $ACTION)
    echo ${CMD[@]}

    ${CMD[@]}
  done
}

#main
if [[ "${BASH_SOURCE[0]}" == "${0}" ]]; then
    set_power "$@"
fi