import base64

import exec_helpers

from si_tests import logger
from si_tests import settings

LOG = logger.logger

RELEASE_DIR = settings.OPENSTACK_DEPLOY_RELEASE_DIR
CONTEXT_DIR = settings.OPENSTACK_DEPLOY_CONTEXT_DIR
REFAPP_DIR = settings.OPENSTACK_DEPLOY_REFAPP_DIR
CLUSTER_INFO_YAML = settings.OPENSTACK_DEPLOY_CLUSTER_INFO_YAML
NODES_METADATA_YAML = settings.OPENSTACK_DEPLOY_NODES_METADATA_YAML
ARTIFACTS_DIR = settings.ARTIFACTS_DIR
CONTEXT_NAME = settings.OPENSTACK_DEPLOY_CONTEXT_NAME


def get_ssh_auth(username=settings.OPENSTACK_DEPLOY_SSH_USERNAME,
                 key_filename=settings.OPENSTACK_DEPLOY_SSH_KEY_PATH):
    return exec_helpers.SSHAuth(
        username=username,
        key_filename=key_filename
    )


def get_ssh_client(ip, auth=None):
    auth = auth or get_ssh_auth()
    return exec_helpers.SSHClient(host=ip, auth=auth)


def get_local_executor():
    return exec_helpers.Subprocess()


def decode(value):
    return base64.b64decode(value).decode("utf-8")
