from si_tests.deployments.utils import wait_utils, commons, kubectl_utils, file_utils
from si_tests.utils import packaging_version as version
from si_tests.deployments.utils.namespace import NAMESPACE


def deploy_stacklight(os_manager, timeout):
    kubectl = kubectl_utils.Kubectl()
    commons.LOG.info("Deploy stacklight")
    kubectl.apply(file_utils.get_example("stacklight/stacklight.yaml"))

    wait = wait_utils.Waiter(os_manager, timeout, NAMESPACE.stacklight)

    deployments = [
        "alerta", "elasticsearch-exporter", "fluentd-notifications",
        "grafana", "kibana", "metricbeat", "mongodb", "netchecker-server",
        "prometheus-es-exporter", "prometheus-kube-state-metrics",
        "prometheus-pushgateway", "prometheus-relay", "telegraf-ucp"]

    # TODO(tleontovich) Delete if below in 2-28 acceptance
    if version.parse(os_manager.os_controller_version()) < version.parse('0.15.4'):
        deployments.append("telegraf-openstack")

    for deployment in deployments:
        commons.LOG.info("Wait for %s deployment", deployment)
        wait.deployment(deployment)

    list_nodes = os_manager.api.nodes.list
    linux_nodes = len(list_nodes(label_selector="kubernetes.io/os=linux"))
    compute_nodes = len(
        list_nodes(label_selector="openstack-compute-node=enabled"))

    telegraf_nodes = len(list_nodes(
        label_selector="openvswitch=enabled,openstack-gateway=enabled"))

    # TODO(opetrenko): fluentd and node-exporter should be deployed on master
    # too, but to enable this, we have to use ucp ui, so for now we assume
    # there is no fluentd on master node

    daemonsets = [
        ("fluentd-elasticsearch", linux_nodes - 1),
        ("netchecker-agent", linux_nodes),
        ("netchecker-agent-hostnet", linux_nodes),
        ("prometheus-libvirt-exporter", compute_nodes),
        ("prometheus-node-exporter", linux_nodes - 1),
        ("telegraf-ds-arping-check", telegraf_nodes)]

    for (daemonset, replicas) in daemonsets:
        commons.LOG.info("Wait for %s daemonset", daemonset)
        wait.daemonset(daemonset, replicas=replicas, namespace=NAMESPACE.vbmc)

    commons.LOG.info("Stacklight successfully deployed")
