from si_tests.deployments.utils import wait_utils, commons, kubectl_utils, file_utils
from si_tests.deployments.utils.namespace import NAMESPACE


def deploy_redis(os_manager, timeout):
    kubectl = kubectl_utils.Kubectl()
    commons.LOG.info("Deploy redis")
    kubectl.apply(file_utils.get_release("80-redis-operator.yaml"))

    wait = wait_utils.Waiter(os_manager, timeout, NAMESPACE.redis)
    commons.LOG.info("Wait for redis operator deployment is ready")
    wait.deployment("os-redis-operator-redisoperator", replicas=1)

    commons.LOG.info("redis is successfully deployed")
