#    Copyright 2022 Mirantis, Inc.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations

from si_tests.clients.k8s import base


class V1TFVrouter(base.BaseModel):
    pass


class V1TFVrouterList(base.BaseModelList):
    pass


class TFVrouter(base.K8sNamespacedResource):
    resource_type = 'tfvrouter'
    model = V1TFVrouter


class TFVrouterManager(base.K8sBaseManager):
    model = V1TFVrouterList
    resource_class = TFVrouter
    resource_group = 'vrouter.tf.mirantis.com'
    resource_version = 'v1alpha1'
    resource_plural = 'tfvrouters'


class V2TFVrouter(base.BaseModel):
    pass


class V2TFVrouterList(base.BaseModelList):
    pass


class TFVrouterV2(base.K8sNamespacedResource):
    resource_type = 'tfvrouter'
    model = V2TFVrouter


class TFVrouterManagerV2(base.K8sBaseManager):
    model = V2TFVrouterList
    resource_class = TFVrouterV2
    resource_group = 'tf.mirantis.com'
    resource_version = 'v2'
    resource_plural = 'tfvrouters'
