#!/usr/bin/env python3

import os
import sys
import yaml

sys.path.append(os.getcwd())
try:
    from si_tests import settings
    from si_tests.managers.kaas_manager import Manager
except ImportError:
    print("ImportError: Run the application from the si-tests directory or "
          "set the PYTHONPATH environment variable to directory which contains"
          " ./si_tests")
    sys.exit(1)


def main():
    if not settings.KUBECONFIG_PATH or not os.path.isfile(
            settings.KUBECONFIG_PATH):
        print("Please set KUBECONFIG environment variable whith"
              "the path to the kubeconfig file for KaaS management cluster")
        return 11

    kaas_manager = Manager(kubeconfig=settings.KUBECONFIG_PATH)
    all_releases = kaas_manager.get_clusterreleases()
    all_ucp_tags = dict()
    for r in all_releases:
        r_name = r.name
        r_ucp_tag = kaas_manager.get_ucp_tag(r_name)
        all_ucp_tags[r_name] = r_ucp_tag

    print(yaml.dump(all_ucp_tags))


if __name__ == '__main__':
    sys.exit(main())
