Example:
```
- name: "Seed node preparation"
  hosts: seed_master
  gather_facts: true
  tags: configure
  roles:
    - micro_ipxe_provisioner
  vars:
    m_ipxe:
      http_addr: 10.0.1.1
      dnsmasq:
        other: |
          dhcp-option=option:dns-server,10.0.1.1
          dhcp-boot=tag:efi,tag:!ipxe,/ipxe.efi,10.0.1.1,10.0.1.1
          dhcp-boot=tag:ipxe,http://10.0.1.1/ipxe/,10.0.1.1
          dhcp-boot=/undionly.kpxe,10.0.1.1,10.0.1.1
          dhcp-range=10.0.1.31,10.0.1.40,255.255.255.0
          # gw
          dhcp-option=3,10.0.1.1
          dhcp-option=option:dns-server,172.19.80.70
      nodes:
        - name: cz1
          bootmacaddress: "52:54:15:41:0b:42"
          bmc_address: 0.0.0.0
          bmc_port: 6231
          bmc_login: admin
          bmc_password: r00tme
          target_netplan:
            version: 2
            ethernets:
              ens3:
                dhcp4: false
                addresses:
                  - 10.0.1.100/24
                gateway4: 10.0.1.1
                nameservers:
                  addresses:
                    - 172.19.80.70
                    - 8.8.8.8
                    - 1.1.1.1
        - name: cz2
          bootmacaddress: "52:54:16:33:cc:13"
          bmc_address: 0.0.0.0
          bmc_port: 6232
          bmc_login: admin
          bmc_password: r00tme
          target_netplan:
            version: 2
            ethernets:
              ens3:
                dhcp4: false
                addresses:
                  - 10.0.1.101/24
                gateway4: 10.0.1.1
                nameservers:
                  addresses:
                    - 172.19.80.70
                    - 8.8.8.8
                    - 1.1.1.1
```

Single disk uefi:

```
# Autogenerated by Subiquity: 2025-08-20 15:04:29.086266 UTC
storage:
  config:
  version: 1
  - ptable: gpt
    serial: 35000c500733a50e6
    wwn: '0x5000c500733a50e6'
    path: /dev/sdb
    wipe: superblock-recursive
    preserve: false
    name: ''
    grub_device: false
    id: disk-sdb
    type: disk
  - device: disk-sdb
    size: 1127219200
    wipe: superblock
    flag: boot
    number: 1
    preserve: false
    grub_device: true
    id: partition-0
    type: partition
  - fstype: fat32
    volume: partition-0
    preserve: false
    id: format-0
    type: format
  - device: disk-sdb
    size: 127719702528
    wipe: superblock
    number: 2
    preserve: false
    grub_device: false
    id: partition-1
    type: partition
  - fstype: ext4
    volume: partition-1
    preserve: false
    id: format-1
    type: format
  - path: /
    device: format-1
    id: mount-1
    type: mount
  - path: /boot/efi
    device: format-0
    id: mount-0
    type: mount

```
