#!/usr/bin/env bash


function _KILL_JOBS() {
  for pid in $(jobs -r -p); do
    if [[ $(ps -p $pid) && $? -eq 0 ]]; then
      kill $pid
    fi
  done
}

function _INT_TERM() {
  echo ""
  echo ["EXIT"]

  _KILL_JOBS

  exit 1;
}

trap _INT_TERM INT TERM
trap _KILL_JOBS EXIT


function set_power(){
  local ACTION=${1:-'status'}
  local TARGET=${2:-'all'}

  local DEFAULT_IPMI="172.18.168.10"
  local DEFAULT_LOGIN="admin"
  local DEFAULT_PASSWORD="password"

  # name ipmi_ip ipmi_port ipmi_login ipmi_password
  local MGMT=(
    'vm-458-0' $DEFAULT_IPMI '50040' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-458-1' $DEFAULT_IPMI '50041' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-458-2' $DEFAULT_IPMI '50042' $DEFAULT_LOGIN $DEFAULT_PASSWORD
  )

  local CHILD=(
    'vm-458-3' $DEFAULT_IPMI '50043' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-458-4' $DEFAULT_IPMI '50044' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-458-5' $DEFAULT_IPMI '50045' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-458-6' $DEFAULT_IPMI '50046' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-458-7' $DEFAULT_IPMI '50047' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-458-8' $DEFAULT_IPMI '50048' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-458-9' $DEFAULT_IPMI '50049' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-458-10' $DEFAULT_IPMI '50050' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-458-11' $DEFAULT_IPMI '50051' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-458-12' $DEFAULT_IPMI '50052' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-458-13' $DEFAULT_IPMI '50053' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-458-14' $DEFAULT_IPMI '50054' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-458-15' $DEFAULT_IPMI '50055' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-458-16' $DEFAULT_IPMI '50056' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-458-17' $DEFAULT_IPMI '50057' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-458-18' $DEFAULT_IPMI '50058' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-458-19' $DEFAULT_IPMI '50059' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-458-20' $DEFAULT_IPMI '50060' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-458-21' $DEFAULT_IPMI '50061' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-458-22' $DEFAULT_IPMI '50062' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-458-23' $DEFAULT_IPMI '50063' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-458-24' $DEFAULT_IPMI '50034' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-458-25' $DEFAULT_IPMI '50035' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-458-26' $DEFAULT_IPMI '50036' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-458-27' $DEFAULT_IPMI '50037' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-458-28' $DEFAULT_IPMI '50038' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-458-29' $DEFAULT_IPMI '50039' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-458-30' $DEFAULT_IPMI '50064' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-458-31' $DEFAULT_IPMI '50065' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-458-32' $DEFAULT_IPMI '50066' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-458-33' $DEFAULT_IPMI '50067' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-458-34' $DEFAULT_IPMI '50068' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-458-35' $DEFAULT_IPMI '50069' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-458-36' $DEFAULT_IPMI '50070' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-458-37' $DEFAULT_IPMI '50071' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-458-38' $DEFAULT_IPMI '50072' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-458-39' $DEFAULT_IPMI '50073' $DEFAULT_LOGIN $DEFAULT_PASSWORD
  )

  case $TARGET in
    mgmt) ARR=( ${MGMT[@]} );
      ;;
    child) ARR=( ${CHILD[@]} );
      ;;
    all) ARR=( ${MGMT[@]} ${CHILD[@]} );
      ;;
  esac

  for i in $(seq 0 5 $(expr ${#ARR[@]} - 1)); do
    echo "node: ${ARR[i]}"
    CMD=(ipmitool -I lanplus -H ${ARR[i+1]} -p ${ARR[i+2]} -U ${ARR[i+3]} -P ${ARR[i+4]} chassis power $ACTION)
    echo ${CMD[@]}

    ${CMD[@]}
  done
}

#main
if [[ "${BASH_SOURCE[0]}" == "${0}" ]]; then
    set_power "$@"
fi