#    Copyright 2022 Mirantis, Inc.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations

from si_tests.clients.k8s import base


class V1TFTest(base.BaseModel):
    pass


class V1TFTestList(base.BaseModelList):
    pass


class TFTest(base.K8sNamespacedResource):
    resource_type = 'tftest'
    model = V1TFTest


class TFTestManager(base.K8sBaseManager):
    model = V1TFTestList
    resource_class = TFTest
    resource_group = 'test.tf.mirantis.com'
    resource_version = 'v1alpha1'
    resource_plural = 'tftests'


class V2TFTest(base.BaseModel):
    pass


class V2TFTestList(base.BaseModelList):
    pass


class TFTestV2(base.K8sNamespacedResource):
    resource_type = 'tftest'
    model = V2TFTest


class TFTestManagerV2(base.K8sBaseManager):
    model = V2TFTestList
    resource_class = TFTestV2
    resource_group = 'tf.mirantis.com'
    resource_version = 'v2'
    resource_plural = 'tftests'
