from si_tests.clients import http_client
from si_tests.clients.iam import keycloak_client
import json


class K8sDashboardClient(object):

    def __init__(self, keycloak_ip, dashboard_url,
                 username, password):
        self.keycloak_ip = keycloak_ip
        self.username = username
        self.password = password
        self.httpclient = http_client.HttpClient(base_url=dashboard_url)

    @property
    def client(self):
        return keycloak_client.KeycloakUserClient(self.keycloak_ip,
                                                  self.username,
                                                  self.password,
                                                  client_id="k8s",
                                                  realm_name="iam")

    @property
    def token(self):
        return self.client.get_token()

    def compose_header(self):
        return {"Content-Type": "application/json",
                "Authorization": "bearer {}".format(self.token)}

    def get_resource(self, resource_name):
        url = "/api/v1/{0}".format(resource_name)
        res = self.httpclient.request(url=url, method='GET',
                                      headers=self.compose_header())
        return json.loads(res.content.decode('utf-8'))
