import pytest

from si_tests import settings
from si_tests import logger

LOG = logger.logger


@pytest.mark.parametrize("_", ["CLUSTER_NAME={0}"
                               .format(settings.CLUSTER_NAME)])
@pytest.mark.usefixtures("store_cluster_description")
def test_get_mgmt_k8s_logs(kaas_manager, _):
    """Get mgmt cluster kubernetes logs"""
    mgmt_cluster = kaas_manager.get_mgmt_cluster()
    mgmt_cluster.download_kubernetes_logs(raise_on_error=True)


@pytest.mark.parametrize("_", ["CLUSTER_NAME={0}"
                               .format(settings.CLUSTER_NAME)])
@pytest.mark.usefixtures("store_cluster_description")
def test_get_mgmt_system_logs(kaas_manager, _):
    """Get mgmt cluster system logs"""
    mgmt_cluster = kaas_manager.get_mgmt_cluster()
    mgmt_cluster.download_system_logs(raise_on_error=True)
