`generate-configuration` role creates a list of network 'devices'
(usually linux bridges) that create L2 network configuration for the lab.

# `generated_configuration`
`generated_configuration` is a variable that is simply a list of configurations:

```yaml
generated_configuration:
  - <network device configuration>
  - <network device configuration>
  ...
```

`<network device configuration>` is a mapping (dict) that describes single
element of configuration, and may contain some L3 configuration. The structure
is the following:

```yaml
name: <string>
rack_id: <int>
device_name: <string>
addresses:
  - <cidr>
forwarding:
  - <destination spec>
uplink:
  - <uplink spec>
```

* `name` is a common name for a group of devices that should belong to the
  same 'network' (for example, 'pxe' network, even with L2 segments in different
  'racks' is a network that is used for PXE booting.)
* `rack_id` is an ID that allows to distinguish devices from the same network
  when they should be in separate L2 segments. In fact, this ID is used for
  adding suffixes to `device_name` so that for different racks there will be
  different devices.
* `device_name` is a real device name that will be added to the system. In most
  cases this value is generated as `<device prefix>-<name>r<rack_id>`, but it
  could be overridden.
* `addresses` - list of IP addresses (with network prefix!) that should be
  assigned to the network device on the seed node. `<cidr>` is a network address
  in the form of `<address>/<prefix>`.
* `forwarding` - a list of destination L2/L3 segments where forwarding is
  allowed to. Each destination is either an L2 segment or L3 network
  address. By default, forwarding between L2 segments is not allowed.
* `uplink` - is a list of 'links' between current device and 'uplink' device(s).
  `<uplink spec>` is a mapping that describes what uplink device should be used
  and additional options like VLAN / VxLAN ids.

# Sources

There are number of variables in inventory that are used as a source for data
for `generated_configuration`:

## `tor_network`

`tor_network` - Top Of Rack device, all other devices should be connected to
that device, directly of via other devices. The structure is the following:

```yaml
tor_network:
  name: <string>
  device_name: <string>
  uplink:
    - <uplink spec>
```
`device_name` usually set explicitly to avoid automatic name generation.

## `seed_network`

`seed_network` defines separate network that is used for bootstrap cluster.

```yaml
seed_network:
  name: <string>
  device_name: <string>
  cidr: <cidr>
  addresses:
    - <cidr>
  forwarding:
    - <destination spec>
  uplink:
    - <uplink spec>
```

`device_name` usually set explicitly to avoid automatic name generation.

`cidr` is not used in generate-configuration, but it is required by
bootstrap template generator to allocate bootstrap cluster addresses from
correct network subnet.

`uplink` should be used in 'flat' network configuration, when bootstrap cluster
and management cluster share the same L2 segment. In multirack configuration
`uplink` should be removed as traffic should flow via routing.

## `l2_layout`

List of rack with networks defined in that specific rack.

```yaml
l2_layout:
  - rack_id: 0
    networks:
      - <network spec>
```

`rack_id` applies to all networks in this block.

Each `<network spec>` could be defined as following:

```yaml
name: <string>
device_name: <int>
addresses:
  - <cidr>
forwarding:
  - <destination spec>
uplink:
  - <uplinks spec>
```

`addresses` could be used to assign IP addresses on the seed node to
enable routing between networks (use `forwarding` for that).

# Specifying an uplink connection

`uplink` is a nested data structure that defines list of 'uplink' devices
current device should be attached to. Single `<uplink spec>`is a mapping that
defines connection with 'uplink' device:

```yaml
lookup: <string>
bridge: <string>
vlan_id: <int>
vxlan_id: <int>
```

* `lookup` defines uplink device lookup expression. It is a string of the form
  `<name>/<rack_id>`. `/<rack_id>` could be omitted, default value for `rack_id`
  is 0.
* `bridge` could be used instead of `lookup` to connect to a specific linux
  bridge device.
* `vlan_id` (optional) VLAN ID if current device should be in a specific VLAN
  with trunk port on uplink device.
* `vxlan_id` (optional) VxLAN ID if current device should be in a specific VxLAN
  on top of uplink device.

Each device could be connected to a number of other devices, either
directly, or with VLAN / VxLAN segregation. Three types of connection are
possible:

* direct
  ```text
  [uplink device]--[veth_a]--[veth_b]--[current device]
  ```
* VxLAN
  ```text
  [uplink device]--[vxlan device]--[current device]
  ```
* VLAN
  ```text
  [uplink device]--[veth_a]--[veth_b]--[veth_b.vlan_id]--[current device]
  ```

# Configuring forwarding between networks

By default, forwarding between L2 segments is not allowed and requires to
be configured explicitly using list of destinations.

```yaml
forwarding:
  - lookup: <L2 segment>
    cidr: <L3 network>
    masquerade: <boolean>
  - ...
```

Destination spec defines where forwarding could be allowed:
* When multiple addresses are configured on a given L2 segment via `addresses`
  key. In this case forwarding between all L3 segments bound to this L2 segment
  is allowed. But still, this doesn't allow forwarding to 'external' L2
  segments or any other L3 segments.
* When destination L2 segment is specified via `lookup` key. In this case
  forwarding is allowed to this particular L2 segment only.
* When destination L3 network is specified via `cidr` key. In this case
  forwarding is allowed to this particular L3 network only.
* `lookup` and `cidr` should not be used together. If this happens forwarding
  would not be allowed.
* Optional `masquerade` key in destination spec enables masquerading
  when forwarding to this destination.
* Traffic that returns back is allowed implicitly.

