from si_tests.deployments.utils import file_utils, wait_utils, commons, kubectl_utils
from si_tests.deployments.utils.namespace import NAMESPACE
from si_tests.utils import utils


@utils.log_method_time()
def deploy_vault(os_manager, timeout):
    kubectl = kubectl_utils.Kubectl()

    commons.LOG.info("Deploy etc")
    etcd_yaml_path = file_utils.get_release("3rd-party/35-etcd.yaml")
    kubectl.apply(etcd_yaml_path)
    vault_yaml_path = file_utils.get_release("3rd-party/40-vault.yaml")

    if NAMESPACE.vault == NAMESPACE.openstack:
        vault_context = file_utils.get_yaml_content(
            file_utils.join(commons.RELEASE_DIR, vault_yaml_path))
        vault_config = vault_context['spec']['releases'][0][
            'values']['vault']['config']

        vault_config['storage']['etcd']['address'] = \
            "http://etcd-vault." + NAMESPACE.etcd_vault + ".svc:2379"

        vault_config['api_addr'] = \
            "http://vault." + NAMESPACE.vault + ".svc:8200"

        vault_yaml_path = file_utils.get_new_name(
            file_utils.join(commons.RELEASE_DIR, vault_yaml_path))
        vault_context['spec']['releases'][0][
            'values']['vault']['config'] = vault_config

        commons.LOG.info("Save vault config to %s", vault_yaml_path)
        file_utils.save_to_yaml(vault_context, vault_yaml_path)

    commons.LOG.info("Deploy Vault")
    kubectl.apply(vault_yaml_path)

    vault_helmbundle = os_manager.get_os_operator_helmbundle("vault")
    etcd_helmbundle = os_manager.get_os_operator_helmbundle("etcd-vault")

    def _wait():
        assert hasattr(vault_helmbundle.read(), "status")
        assert hasattr(etcd_helmbundle.read(), "status")
        return True

    wait = wait_utils.Waiter(os_manager, timeout)
    wait.wait_pass(_wait, expected=AssertionError)

    commons.LOG.info("Wait for etcd statefulset")
    wait.statefulset("etcd-vault-etcd",
                     replicas=3,
                     namespace=NAMESPACE.etcd_vault)

    commons.LOG.info("Wait for vault statefulset")
    wait.statefulset("vault",
                     replicas=3,
                     namespace=NAMESPACE.vault)

    commons.LOG.info("Vault successfully deployed")
