# coding: utf-8

"""
    Inference Box API

    ## Welcome to Inference Box API  A comprehensive REST API for managing cloud infrastructure resources including ML inference deployments, Kubernetes resources, and application lifecycle management.  ## Overview  Inference Box API is a cloud-native REST API service that provides unified access to manage:  - **ML Inference Deployments**: Create, manage, and scale machine learning inference services - **Slurm Clusters**: Deploy, configure, and manage HPC Slurm clusters for batch workloads - **Kubernetes Resources**: Manage namespaces (projects), pods, secrets, volumes, and other K8s resources - **Application Lifecycle**: Deploy and manage applications from catalog templates - **Resource Management**: Handle flavors, capacities, quotas, and node groups - **User & Access Control**: Manage users, groups, and API keys with RBAC integration - **Monitoring & Metrics**: Query metrics and monitor resource usage via Victoria Metrics  The service is built with Go and integrates with Kubernetes, HashiCorp Vault, and Victoria Metrics to provide a complete cloud infrastructure management solution.  ## Key API Endpoints  - **Inference**: `/v1/{project_name}/inferences` - ML inference deployment management - **Slurm Clusters**: `/v1/{project_name}/slurm/clusters` - Slurm cluster deployment and management - **Flavors**: `/v1/flavors` - Compute resource flavor definitions - **Users**: `/v1/admin/users` - User management (admin only) - **Projects**: `/v1/{project_name}` - Project-scoped resource operations - **Metrics**: `/v1/{project_name}/metrics` - Resource usage metrics  ## Getting Started  ### Authentication  All API requests require authentication using the `X-API-Key` header. Most operations are scoped to specific projects/namespaces.  ### API Organization  The API is organized into logical groups: - **Public endpoints**: `/v1/*` - General access endpoints - **Project-scoped**: `/v1/{project_name}/*` - Project-specific resources - **Admin endpoints**: `/v1/admin/*` - Administrative operations  ### Documentation  Interactive documentation is available at `/docs` when the service is running. 

    The version of the OpenAPI document: 2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from si_tests.clients.gcore.box_api.models.api_util_references_object_reference import ApiUtilReferencesObjectReference
from si_tests.clients.gcore.box_api.models.v1_empty_dir_volume_source import V1EmptyDirVolumeSource
from si_tests.clients.gcore.box_api.models.v1_image_volume_source import V1ImageVolumeSource
from si_tests.clients.gcore.box_api.models.v1_pvc_volume_source import V1PVCVolumeSource
from si_tests.clients.gcore.box_api.models.v1_regional_volume_status import V1RegionalVolumeStatus
from typing import Optional, Set
from typing_extensions import Self

class V1VolumeResponse(BaseModel):
    """
    V1VolumeResponse
    """ # noqa: E501
    empty_dir: Optional[V1EmptyDirVolumeSource] = None
    image: Optional[V1ImageVolumeSource] = None
    managed: Optional[StrictBool] = Field(default=None, description="Managed indicates whether the volume is managed by another object. A managed volume cannot be modified or deleted directly.")
    name: Optional[StrictStr] = Field(default=None, description="Name is the volume name")
    object_references: Optional[List[ApiUtilReferencesObjectReference]] = Field(default=None, description="ObjectReferences lists parent objects referencing this volume.")
    pvc: Optional[V1PVCVolumeSource] = None
    regions: Optional[List[StrictStr]] = Field(default=None, description="Regions is the list of regions where the volume should be available.")
    status: Optional[StrictStr] = Field(default=None, description="Status is the combined volume status across regions, e.g. \"Active\" or \"Pending\".")
    statuses: Optional[Dict[str, V1RegionalVolumeStatus]] = Field(default=None, description="Statuses is a map of regional volume statuses keyed by region name.")
    __properties: ClassVar[List[str]] = ["empty_dir", "image", "managed", "name", "object_references", "pvc", "regions", "status", "statuses"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V1VolumeResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of empty_dir
        if self.empty_dir:
            _dict['empty_dir'] = self.empty_dir.to_dict()
        # override the default output from pydantic by calling `to_dict()` of image
        if self.image:
            _dict['image'] = self.image.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in object_references (list)
        _items = []
        if self.object_references:
            for _item_object_references in self.object_references:
                if _item_object_references:
                    _items.append(_item_object_references.to_dict())
            _dict['object_references'] = _items
        # override the default output from pydantic by calling `to_dict()` of pvc
        if self.pvc:
            _dict['pvc'] = self.pvc.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each value in statuses (dict)
        _field_dict = {}
        if self.statuses:
            for _key_statuses in self.statuses:
                if self.statuses[_key_statuses]:
                    _field_dict[_key_statuses] = self.statuses[_key_statuses].to_dict()
            _dict['statuses'] = _field_dict
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V1VolumeResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "empty_dir": V1EmptyDirVolumeSource.from_dict(obj["empty_dir"]) if obj.get("empty_dir") is not None else None,
            "image": V1ImageVolumeSource.from_dict(obj["image"]) if obj.get("image") is not None else None,
            "managed": obj.get("managed"),
            "name": obj.get("name"),
            "object_references": [ApiUtilReferencesObjectReference.from_dict(_item) for _item in obj["object_references"]] if obj.get("object_references") is not None else None,
            "pvc": V1PVCVolumeSource.from_dict(obj["pvc"]) if obj.get("pvc") is not None else None,
            "regions": obj.get("regions"),
            "status": obj.get("status"),
            "statuses": dict(
                (_k, V1RegionalVolumeStatus.from_dict(_v))
                for _k, _v in obj["statuses"].items()
            )
            if obj.get("statuses") is not None
            else None
        })
        return _obj


