# si_tests.clients.gcore.box_api.SecretsApi

All URIs are relative to *http://localhost*

Method | HTTP request | Description
------------- | ------------- | -------------
[**v1_create_secret**](SecretsApi.md#v1_create_secret) | **POST** /v1/{project_name}/secrets | Create secret
[**v1_delete_secret**](SecretsApi.md#v1_delete_secret) | **DELETE** /v1/{project_name}/secrets/{secret_name} | Delete secret
[**v1_get_secret**](SecretsApi.md#v1_get_secret) | **GET** /v1/{project_name}/secrets/{secret_name} | Get secret
[**v1_list_secrets**](SecretsApi.md#v1_list_secrets) | **GET** /v1/{project_name}/secrets | List secrets
[**v1_update_secret**](SecretsApi.md#v1_update_secret) | **PATCH** /v1/{project_name}/secrets/{secret_name} | Update secret


# **v1_create_secret**
> ApiServicesSecretsV1SecretResponse v1_create_secret(project_name, v1_create_secret_request)

Create secret

This endpoint creates a new secret that can be used in inference deployments.

Secrets are used to store sensitive information such as API keys or access tokens.
Currently, secrets can only be used with inference deployments that have an SQS trigger type.
This is the only supported use case for secrets at this time.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.api_services_secrets_v1_secret_response import ApiServicesSecretsV1SecretResponse
from si_tests.clients.gcore.box_api.models.v1_create_secret_request import V1CreateSecretRequest
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.SecretsApi(api_client)
    project_name = 'project_name_example' # str | Project name
    v1_create_secret_request = si_tests.clients.gcore.box_api.V1CreateSecretRequest() # V1CreateSecretRequest | Secret body

    try:
        # Create secret
        api_response = api_instance.v1_create_secret(project_name, v1_create_secret_request)
        print("The response of SecretsApi->v1_create_secret:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling SecretsApi->v1_create_secret: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **project_name** | **str**| Project name | 
 **v1_create_secret_request** | [**V1CreateSecretRequest**](V1CreateSecretRequest.md)| Secret body | 

### Return type

[**ApiServicesSecretsV1SecretResponse**](ApiServicesSecretsV1SecretResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**201** | Created |  -  |
**400** | Bad Request |  -  |
**409** | Conflict |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_delete_secret**
> v1_delete_secret(project_name, secret_name)

Delete secret

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.SecretsApi(api_client)
    project_name = 'project_name_example' # str | Project name
    secret_name = 'secret_name_example' # str | Secret name

    try:
        # Delete secret
        api_instance.v1_delete_secret(project_name, secret_name)
    except Exception as e:
        print("Exception when calling SecretsApi->v1_delete_secret: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **project_name** | **str**| Project name | 
 **secret_name** | **str**| Secret name | 

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |
**404** | Not Found |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_get_secret**
> ApiServicesSecretsV1SecretResponse v1_get_secret(project_name, secret_name)

Get secret

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.api_services_secrets_v1_secret_response import ApiServicesSecretsV1SecretResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.SecretsApi(api_client)
    project_name = 'project_name_example' # str | Project name
    secret_name = 'secret_name_example' # str | Secret name

    try:
        # Get secret
        api_response = api_instance.v1_get_secret(project_name, secret_name)
        print("The response of SecretsApi->v1_get_secret:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling SecretsApi->v1_get_secret: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **project_name** | **str**| Project name | 
 **secret_name** | **str**| Secret name | 

### Return type

[**ApiServicesSecretsV1SecretResponse**](ApiServicesSecretsV1SecretResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_list_secrets**
> V1ListSecretResponse v1_list_secrets(project_name)

List secrets

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_list_secret_response import V1ListSecretResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.SecretsApi(api_client)
    project_name = 'project_name_example' # str | Project name

    try:
        # List secrets
        api_response = api_instance.v1_list_secrets(project_name)
        print("The response of SecretsApi->v1_list_secrets:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling SecretsApi->v1_list_secrets: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **project_name** | **str**| Project name | 

### Return type

[**V1ListSecretResponse**](V1ListSecretResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**400** | Bad Request |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_update_secret**
> ApiServicesSecretsV1SecretResponse v1_update_secret(project_name, secret_name, v1_update_secret_request)

Update secret

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.api_services_secrets_v1_secret_response import ApiServicesSecretsV1SecretResponse
from si_tests.clients.gcore.box_api.models.v1_update_secret_request import V1UpdateSecretRequest
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.SecretsApi(api_client)
    project_name = 'project_name_example' # str | Project name
    secret_name = 'secret_name_example' # str | Secret name
    v1_update_secret_request = si_tests.clients.gcore.box_api.V1UpdateSecretRequest() # V1UpdateSecretRequest | Secret body

    try:
        # Update secret
        api_response = api_instance.v1_update_secret(project_name, secret_name, v1_update_secret_request)
        print("The response of SecretsApi->v1_update_secret:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling SecretsApi->v1_update_secret: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **project_name** | **str**| Project name | 
 **secret_name** | **str**| Secret name | 
 **v1_update_secret_request** | [**V1UpdateSecretRequest**](V1UpdateSecretRequest.md)| Secret body | 

### Return type

[**ApiServicesSecretsV1SecretResponse**](ApiServicesSecretsV1SecretResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**400** | Bad Request |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

