# Test environment using openstack heat backend

| :warning: WARNING                                                    |
|:---------------------------------------------------------------------|
| Current state of templates and logic around: PoC for internal usage. |
| Don't expect it would be easy to re-use out-of-the box               |
| Please refer to them, only like examples.                            |

## Description

This document ***only*** shows how-to locally run current set of tests, to
get k0rdent-bm virtual env.

```text
# ksi/
tree -L 1
.
├── env1_p1_test_infra.sh  # stage1
├── env1_p2_remote_install_k0s.sh  # stage2 and etc
├── env1_p3_remote_install_kcm.sh
├── env1_p4_remote_install_metal3.sh
├── id_ed_ksiuser  << private key, to access seed node

```

Stage1: spawn seed node and `ksi_config.yaml`

```shell
#!/bin/env bash

set -ex

export KSI_OS_CLOUDS_YAML_PATH="path/to/my/private/clouds.yaml"
export KSI_OS_CLOUD_NAME="mycloud"
export KSI_KEEP_ENV_BEFORE='false'
#
export ENV_NAME='user-ksi1'
export KSI_ENV_CONFIG_NAME="os-virtual"
export ARTIFACTS_DIR="_temp/${ENV_NAME}/artifacts/"
rm -rf "${ARTIFACTS_DIR}"
mkdir -p ${ARTIFACTS_DIR}
# KSI REMOTE DATA
export KSI_SEED_SSH_PRIV_KEY_FILE='id_ed_ksiuser'
ksi-runtest config-create  > "${ARTIFACTS_DIR}/ksi_config.yaml"
export KSI_CONFIG_PATH="${ARTIFACTS_DIR}/ksi_config.yaml"
#
py.test --color=yes --junit-xml=${ARTIFACTS_DIR}/tests_report.xml si_tests/tests/infra/openstack/test_create_env.py
```

Stage2: **KSI_RUN_ON_REMOTE=true** Install `k0s` at remote seed node

```shell

#!/bin/env bash
set -ex
# prepare test bins
if [ -f 'bin/kubectl' ]; then
  mkdir bin
  curl -L "https://dl.k8s.io/release/$(curl -L -s https://dl.k8s.io/release/stable.txt)/bin/linux/amd64/kubectl" --output bin/kubectl
  curl -sSL https://get.helm.sh/helm-v3.17.3-linux-amd64.tar.gz | tar xz --strip-components=1 -C bin/ linux-amd64/helm
  chmod 0755 bin/*
fi
#
export ENV_NAME='user-ksi1'
export KSI_RUN_ON_REMOTE='true'
export KSI_ENV_CONFIG_NAME="os-virtual"
export ARTIFACTS_DIR="_temp/${ENV_NAME}/artifacts/"
export KSI_CONFIG_PATH="${ARTIFACTS_DIR}/ksi_config.yaml"
export KSI_SEED_WORKSPACE_PATH_USE_CACHE=true
export KSI_K0S_APPLY_REGISTRY_HACK=true
# since we hardcode path for dev-runs, need to fix reverse-sync also..
export KSI_SEED_DOWNLOAD_DIRS="_temp:_temp"
#
R_TEST="si_tests/tests/bootstrap/test_install_seed_install_k0s.py"
ksi-runtest exec --config-path=${ARTIFACTS_DIR}/ksi_config.yaml '--command=py.test --color=yes '${R_TEST}' 2>&1'

```

Stage3: **KSI_RUN_ON_REMOTE=true** Install `k0s` at remote seed node

```shell
#!/bin/env bash
set -ex

export ENV_NAME='user-ksi1'
export KSI_RUN_ON_REMOTE='true'
export KSI_ENV_CONFIG_NAME="os-virtual"
export ARTIFACTS_DIR="_temp/${ENV_NAME}/artifacts/"
export KSI_CONFIG_PATH="${ARTIFACTS_DIR}/ksi_config.yaml"
export KSI_SEED_WORKSPACE_PATH_USE_CACHE=true
export KSI_SEED_DOWNLOAD_DIRS="_temp:_temp"
#
export KUBECONFIG="${ARTIFACTS_DIR}/bootstrap_kubeconfig.yaml"
#
export KCM_SOURCE="opensource"
export KCM_CHART_VERSION="0.3.0"
#
R_TEST="si_tests/tests/bootstrap/test_install_kcm.py"

ksi-runtest exec --config-path=${ARTIFACTS_DIR}/ksi_config.yaml '--command=py.test --color=yes '${R_TEST}' 2>&1'
```

Stage4: **KSI_RUN_ON_REMOTE=true** Install `k0rdent-bm` chunks

```shell
#!/bin/env bash
set -ex

# prepare test bins
if [ -f 'bin/kubectl' ]; then
  mkdir bin
  curl -L "https://dl.k8s.io/release/$(curl -L -s https://dl.k8s.io/release/stable.txt)/bin/linux/amd64/kubectl" --output bin/kubectl
  curl -sSL https://get.helm.sh/helm-v3.17.3-linux-amd64.tar.gz | tar xz --strip-components=1 -C bin/ linux-amd64/helm
  chmod 0755 bin/*
fi
#
export ENV_NAME='user-ksi1'
export KSI_RUN_ON_REMOTE='true'
export KSI_ENV_CONFIG_NAME="os-virtual"
export ARTIFACTS_DIR="_temp/${ENV_NAME}/artifacts/"
export KSI_CONFIG_PATH="${ARTIFACTS_DIR}/ksi_config.yaml"
export KSI_SEED_WORKSPACE_PATH_USE_CACHE=true
#
export KSI_KUBECONFIG_PATH="${ARTIFACTS_DIR}/bootstrap_kubeconfig.yaml"
#
export KSI_SECRET_REGISTRY_CI_MIRANTIS_COM_USERNAME='XXXXXXXXx'
export KSI_SECRET_REGISTRY_CI_MIRANTIS_COM_PASSWORD='YYYYYYYYY'
#
export KCM_SOURCE="opensource"
export KSI_BAREMETAL_CAPI_PROVIDER_METAL3_CHART_VERSION='0.0.0-518373e'

R_TEST="si_tests/tests/bootstrap/test_install_seed_install_bm.py"
ksi-runtest exec --config-path=${ARTIFACTS_DIR}/ksi_config.yaml '--command=py.test --color=yes --junit-xml=artifacts/tests_report.xml '${R_TEST}' 2>&1'

```
