# k0rdent System Integration (KSI) Tests


## Table of Contents
- [k0rdent System Integration (KSI) Tests](#k0rdent-system-integration-ksi-tests)
  - [Table of Contents](#table-of-contents)
  - [Test Suites](#test-suites)
  - [Overview](#overview)
  - [Prerequisites](#prerequisites)
  - [Install requirements](#install-requirements)
  - [Usage Examples](#usage-examples)
    - [Bootstrap kcm test](#bootstrap-kcm-test)
    - [Deployment test](#deployment-test)
      - [AWS example](#aws-example)
    - [Over-deployment tests (tests with existing cluster)](#over-deployment-tests-tests-with-existing-cluster)
      - [Service Templates applying](#service-templates-applying)
    - [Other Links](#other-links)

## Test Suites
- [Bootstrap](si_tests/tests/bootstrap/README.md)
- [Cluster Deployments](si_tests/tests/clusterdeployments/README.md)
- LCM
  - [Repositories](si_tests/tests/lcm/repositories/README.md)
  - [Service Templates](si_tests/tests/lcm/servicetemplates/README.md)
- [Inference](si_tests/tests/inference/README.md)
- Infrastructure
  - [OpenStack](si_tests/tests/infra/openstack/README.md)

## Overview
Integration tests for the k0rdent. Inspired by si-tests of MCC.

## Prerequisites

- Requires (so far) k8s cluster with k0rdent [kcm](https://github.com/k0rdent/kcm) installed.
- Python 3.12 (3.10 should work)

## Install requirements
```shell
venv ~/Workspace/venv; source ~/Workspace/venv/bin/activate
cd ksi/
pip install -r ./si_tests/requirements.txt

# optionally, install ksi-runtest, only for dev-purposes only
pip3 install -e ksi/packages
# versify:
# ksi-runtest -h
```

## Usage Examples

### Bootstrap kcm test

This requires helm (v3) binary located in ${KSI_DIR}/bin or system-wide
```shell
export KUBECONFIG=kubeconfig_from_kind_or_k0s_or_any_available_cluster
export KCM_CHART_VERSION='0.1.0' # for release version.
# KCM_CHART_VERSION='0.1.0-80-g0708b9e' # for PR/CI usage. That will force installation from ci repos
py.test --color=yes si_tests/tests/bootstrap/test_install_kcm.py
```

### Deployment test

#### AWS example

```bash
export KUBECONFIG=kubeconfig_from_kind_with_kcm_installed
export AWS_ACCESS_KEY_ID='EXAMPLE_ACCESS_KEY_ID'
export AWS_SECRET_ACCESS_KEY='EXAMPLE_SECRET_ACCESS_KEY'
export KCM_CLUSTER_DEPLOYMENT_NAME='MY_CLUSTER_DEPLOYMENT'
py.test --color=yes si_tests/tests/clusterdeployments/test_create_aws_clusterdeployment.py
```

Now take your coffee and wait for deployment and afterdeployment checks.

### Over-deployment tests (tests with existing cluster)
#### Service Templates applying
```shell
export KUBECONFIG=kubeconfig_from_kind_with_kcm_which_deployed_this_cld
export TARGET_CLD='MY_CLUSTER_DEPLOYMENT' # Name of the cluster deployment from previous step
export TARGET_NAMESPACE='kcm-system' # Namespace where your cluster is (so far deploymnet with ksi possible only to kcm-system)
export SERVICE_TEMPLATES_LIST='cert-manager-1-16-2,external-secrets-0-11-0' # svctmpl to install into cluster
py.test --color=yes si_tests/tests/lcm/test_servicetemplates_actions.py
```
### Other Links
- [Architecture Diagram](docs/architecture.md)
- [Class Diagram](docs/class-diagram.md)
- [Openstack Heatstack Environment](docs/openstack-heat-env-readme.md)
- [Openstack Heatstack Environment Example](docs/openstack-heat-virt-env-example.md)
