# Clusterdeployment test module

## Overview
This directory contains different tests related to clusterdeployment management (CRUD).

## Test Suite

- [Deploy managed clusterdeployment on AWS](#test_create_aws_clusterdeploymentpy)
- [Deploy managed clusterdeployment on AWS/EKS](#test_create_eks_clusterdeploymentpy)
- [Deploy managed clusterdeployment on Azure](#test_create_azure_clusterdeploymentpy)
- [Deploy managed clusterdeployment on Azure/AKS](#test_create_aks_clusterdeploymentpy)
- [Deploy managed clusterdeployment on OpenStack](#test_create_os_clusterdeploymentpy)
- [Deploy managed clusterdeployment on vSphere](#test_create_vsphere_clusterdeploymentpy)
- [Deploy managed clusterdeployment on GCP](#test_create_gcp_clusterdeploymentpy)
- [Hosted clusters](#hosted-clsuters)
  - [Deploy managed hosted clusterdeployment on vSphere](#test_create_vsphere_hosted_clusterdeploymentpy)
- [Regional clusters](#regional-clusters)
  - [Deploy managed regional clusterdeployment on OpenStack](#test_create_os_regional_clusterdeploymentpy)
- [Cluster removal test](#cluster-removal-test-test_delete_clusterdeploymentpy)
- [Add Custom ClusterTemplate](#add-custom-clustertemplate-test_add_clustertemplatepy)


## Pre-requisites

- Working k0rdent kcm installation required to execute any of those tests

## Detailed description of common checks inside tests and each test separately

### Common checks

Prior to each test, a pre-flight check of the environment variables required for provider authentication will fail if any are missing.

Each test (except removal one) deploy the cluster (create clusterdeployment) in corresponding cloud.
Besides since k0rdent cld is a common unified resource - we're able to unify checks

Currently existing checks:
- Check that nodes in the deployed cluster in expected state (expected by default - Running and Ready)
- Check that we have no crashlooping pods in the deployed cluster
- Check statuses of clusterdeployment object (expected to be Ready=True as concatenation of conditions inside)

### Expected pods check

For each clustertemplate we have fixed set of expected pod objects inside cluster. 
The templates with this information located in `~/{ksi_home}/si_tests/templates/expected-pods/cluster`
It's required to update (add new) templates each time when the new template appearing in kcm.

## Common variables for each test and customisation of runs

| ENV Variable                         | Type     | Description                                                                                                                                                                                                                                                                            | Defaults                              |
|--------------------------------------|----------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|---------------------------------------|
| `KUBECONFIG`                         | `<str>`  | Path to KCM cluster KUBECONFIG                                                                                                                                                                                                                                                         |                                       |
| `KCM_CLUSTER_DEPLOYMENT_NAME`        | `<str>`  | Represents cluster deployment name                                                                                                                                                                                                                                                     | `ksi-managed-cluster`                 |
| `KCM_CLUSTER_DEPLOYMENT_NAMESPACE`   | `<str>`  | The cluster deployment namespace. So far should not be changed and by default the value is 'kcm-system'. In future when access management config will be added - we will be able to create separated namespaces for deployments                                                        | `kcm-system`                          |
| `KCM_CLUSTER_TEMPLATE_NAME`          | `<str>`  | Desired cluster template name (`kubectl get clustertemplate -n kcm-system`) if needs to deploy not default template (in case of previous version). By default - unfilled. Each test have it's own cluster template. Each cluster template should have it's own expected pods template. | Not set globally. Depends on template |
| `CHECK_CLUSTER_READINESS_TIMEOUT`    | `<int>`  | Time-to-wait for cluster deployment to become Ready.                                                                                                                                                                                                                                   | 7200s (2h)                            |
| `ENABLE_INTROSPECT_CAP_ERRORS`       | `<bool>` | Enable or not logging of errors inside CAPI controllers. Quite useful in debug puproses.                                                                                                                                                                                               | `False`                               |
| `SKIP_EXPECTED_POD_CHECK`            | `<bool>` | Whether or not skip expected pods check. Can be useful in new templates adding                                                                                                                                                                                                         | `False`                               |
| `ENABLE_INTROSPECT_CAP_ERRORS`       | `<bool>` | Check cap* pods for errors during waiting for ClusterDeployment readiness, and print the errors to logs. This helps to catch the provider-specific errors that are not shown in the "conditions" for the providers objets, like Cluster or Machines.                                   | `False`                               |
| `CHECK_ACTUAL_EXPECTED_PODS_TIMEOUT` | `<int>`  | Time-to-wait for all expected pods will be in place                                                                                                                                                                                                                                    | 300                                   |
| `WAIT_PODS_READY_TIMEOUT`            | `<int>`  | Time-to-wait for all pods to have Ready and Running statuses                                                                                                                                                                                                                           | 1800                                  |
| `KCM_CLUSTER_CONTROLPLANE_NUMBER`    | `<int>`  | Controlplane machines count                                                                                                                                                                                                                                                            | 3                                     |
| `KCM_CLUSTER_WORKERS_NUMBER`         | `<int>`  | Worker machines count                                                                                                                                                                                                                                                                  | 2                                     |
| `CUSTOM_CLUSTERDEPLOYMENT_PATH`      | `<str>`  | (optional) Path to a ClusterDeployment yaml with pre-defined services. Supports Jinja2 to use environment variables and to create extra objects (see example in templates/deploy-objects/clusterdeployments/default/clusterdeployment.yaml)                                            | ''                                    |

## Existing tests and requirements

### test_create_aws_clusterdeployment.py
This test creates AWS standalone clusterdeployment.

#### Variables that MUST be filled before run and have no default value
| ENV Variable            | Type    | Desctiption                                          |
|-------------------------|---------|------------------------------------------------------|
| `AWS_ACCESS_KEY_ID`     | `<str>` | AWS Access Key ID generated in AWS IAM dashboard     |
| `AWS_SECRET_ACCESS_KEY` | `<str>` | AWS Secret Access Key generated in AWS IAM dashboard |

#### Optional variables to customise the deployment
| ENV Variable                 | Type    | Desctiption                                | Defaults          |
|------------------------------|---------|--------------------------------------------|-------------------|
| `AWS_DEFAULT_REGION`         | `<str>` | AWS region to deploy cluster               | us-east-2         |
| `AWS_DEFAULT_AZ`             | `<str>` | Default AZ of the region to deploy cluster | us-east-2a        |
| `AWS_INSTANCE_TYPE_CTL`      | `<str>` | AWS instance type for control plane        | t3.small          |
| `AWS_INSTANCE_TYPE_WRK`      | `<str>` | AWS instance type for worker               | t3.small          |
| `AWS_INSTANCE_AMI_CTL`       | `<str>` | Instance image for control plane           | Unset             |
| `AWS_INSTANCE_AMI_WRK`       | `<str>` | Instance image for worker                  | Unset             |
| `AWS_INSTANCE_ROOT_SIZE_CTL` | `<int>` | Root disk size in GB for control plane     | 0 (chosed by aws) |
| `AWS_INSTANCE_ROOT_SIZE_WRK` | `<int>` | Root disk size in GB for worker            | 0 (chosed by aws) |


### test_create_eks_clusterdeployment.py
This test creates AWS EKS clusterdeployment.

#### Variables that MUST be filled before run and have no default value
| ENV Variable            | Type    | Desctiption                                          |
|-------------------------|---------|------------------------------------------------------|
| `AWS_ACCESS_KEY_ID`     | `<str>` | AWS Access Key ID generated in AWS IAM dashboard     |
| `AWS_SECRET_ACCESS_KEY` | `<str>` | AWS Secret Access Key generated in AWS IAM dashboard |

#### Optional variables to customise the deployment
| ENV Variable                 | Type    | Desctiption                                | Defaults          |
|------------------------------|---------|--------------------------------------------|-------------------|
| `AWS_DEFAULT_REGION`         | `<str>` | AWS region to deploy cluster               | us-east-2         |
| `AWS_INSTANCE_TYPE_WRK`      | `<str>` | AWS instance type for worker               | t3.small          |
| `AWS_INSTANCE_AMI_WRK`       | `<str>` | Instance image for worker                  | Unset             |
| `AWS_INSTANCE_ROOT_SIZE_WRK` | `<int>` | Root disk size in GB for worker            | 0 (chosed by aws) |


### test_create_azure_clusterdeployment.py
This test creates Azure standalone clusterdeployment

#### Variables that MUST be filled before run and have no default value
| ENV Variable            | Type    | Desctiption                                                                                        |
|-------------------------|---------|----------------------------------------------------------------------------------------------------|
| `AZURE_SUBSCRIPTION_ID` | `<str>` | Subscription ID that can be obtained using `az account list -o table`                              |
| `AZURE_CLIENT_ID`       | `<str>` | appId that can be obtained during creation of azure service principal                              |
| `AZURE_TENANT_ID`       | `<str>` | Tenant ID that can be obtained using `az account list -o table`                                    |
| `AZURE_CLIENT_SECRET`   | `<str>` | Service Principal password field. Will be shown during process of creation azure service principal |

#### Optional variables to customise the deployment
| ENV Variable             | Type    | Desctiption                       | Defaults       |
|--------------------------|---------|-----------------------------------|----------------|
| `AZURE_CLUSTER_LOCATION` | `<str>` | Azure location to deploy cluster  | westus2        |
| `AZURE_VM_SIZE_CTL`      | `<str>` | Azure vm flavor for control plane | Standard_A4_v2 |
| `AZURE_VM_SIZE_WRK`      | `<str>` | Azure vm flavor for worker        | Standard_A4_v2 |


### test_create_aks_clusterdeployment.py
This test creates Azure AKS clusterdeployment

#### Variables that MUST be filled before run and have no default value
| ENV Variable            | Type    | Desctiption                                                                                        |
|-------------------------|---------|----------------------------------------------------------------------------------------------------|
| `AZURE_SUBSCRIPTION_ID` | `<str>` | Subscription ID that can be obtained using `az account list -o table`                              |
| `AZURE_CLIENT_ID`       | `<str>` | appId that can be obtained during creation of azure service principal                              |
| `AZURE_TENANT_ID`       | `<str>` | Tenant ID that can be obtained using `az account list -o table`                                    |
| `AZURE_CLIENT_SECRET`   | `<str>` | Service Principal password field. Will be shown during process of creation azure service principal |

#### Optional variables to customise the deployment
| ENV Variable             | Type    | Desctiption                       | Defaults       |
|--------------------------|---------|-----------------------------------|----------------|
| `AZURE_CLUSTER_LOCATION` | `<str>` | Azure location to deploy cluster  | westus2        |
| `AZURE_VM_SIZE_CTL`      | `<str>` | Azure vm flavor for control plane | Standard_A4_v2 |
| `AZURE_VM_SIZE_WRK`      | `<str>` | Azure vm flavor for worker        | Standard_A4_v2 |

### test_create_os_clusterdeployment.py
This test creates OpenStack standalone clusterdeployment

> **_NOTE:_** Most of these variables can be obtained by downloading openstack-rc file after creation of OS Application ID.

#### Variables that MUST be filled before run and have no default value
| ENV Variable                       | Type    | Desctiption                                                                                                                      |
|------------------------------------|---------|----------------------------------------------------------------------------------------------------------------------------------|
| `OS_APPLICATION_CREDENTIAL_ID`     | `<str>` | OpenStack Application Credential ID (can be obtaining by creating application credential via settings page inside OpenStack)     |
| `OS_APPLICATION_CREDENTIAL_SECRET` | `<str>` | OpenStack Application Credential Secret (can be obtaining by creating application credential via settings page inside OpenStack) |

#### Optional variables to customise the deployment
| ENV Variable              | Type    | Desctiption                                                                                            | Defaults                                 |
|---------------------------|---------|--------------------------------------------------------------------------------------------------------|------------------------------------------|
| `OS_AUTH_URL`             | `<str>` | OpenStack Keystone URL                                                                                 | https://keystone.ic-eu.ssl.mirantis.net/ |
| `OS_REGION_NAME`          | `<str>` | OpenStack Region                                                                                       | RegionOne                                |
| `OS_INTERFACE`            | `<str>` | Public interface to connect network during deployment process                                          | public                                   |
| `OS_IDENTITY_API_VERSION` | `<str>` | OpenStack Keystone Identity API version                                                                | 3                                        |
| `OS_AUTH_TYPE`            | `<str>` | OpenStack Auth Type                                                                                    | v3applicationcredential                  |
| `OS_CTL_MACHINE_FLAVOR`   | `<str>` | OpenStack Flavor to deploy control plane machines                                                      | cfg.dev                                  |
| `OS_WRK_MACHINE_FLAVOR`   | `<str>` | OpenStack Flavor to deploy workers' machines                                                           | k8s_contrail.cid                         |
| `OS_INSTANCE_IMAGE_NAME`  | `<str>` | Image to be used for instance creation                                                                 | ubuntu-24.04-x86_64                      |
| `KSI_OS_SECURITY_GROUP`   | `<str>` | Security group to be used for created instances. Will disable creation of CAPI managed secutiry group. | None                                     |
| `KSI_OS_KEYPAIR_NAME`     | `<str>` | Name of the keypair to assign to instance                                                              | None                                     |

### test_create_vsphere_clusterdeployment.py
This test creates vSphere standalone clusterdeployment 

#### Variables that MUST be filled before run and have no default value
| ENV Variable                        | Type    | Desctiption                                                         |
|-------------------------------------|---------|---------------------------------------------------------------------|
| `VSPHERE_SERVER_ADDR`               | `<str>` | vSphere vCenter address                                             |
| `VSPHERE_DATACENTER_NAME`           | `<str>` | Name of vSphere vCenter                                             |
| `VSPHERE_DATASTORE_PATH`            | `<str>` | Path to datastore                                                   |
| `VSPHERE_USER`                      | `<str>` | vSphere user                                                        |
| `VSPHERE_PASSWORD`                  | `<str>` | vSphere password                                                    |
| `VSPHERE_NETWORK_PATH`              | `<str>` | Network path                                                        |
| `VSPHERE_VM_TEMPLATE_PATH`          | `<str>` | VM template path (image analogue)                                   |
| `VSPHERE_RESOURCE_POOL_PATH`        | `<str>` | Resource path of vSphere                                            |
| `VSPHERE_FOLDER_PATH`               | `<str>` | vSphere folder (usually user folder to store vms)                   |
| `VSPHERE_CONTROL_PLANE_ENDPOINT_IP` | `<str>` | Manually (so far) discovered suitable IP from pool to make endpoint |

#### Optional variables to customise the deployment
| ENV Variable               | Type    | Desctiption                         | Defaults                                    |
|----------------------------|---------|-------------------------------------|---------------------------------------------|
| `VSPHERE_MACHINE_CPU`      | `<int>` | CPU to allocate per machine         | 2                                           |
| `VSPHERE_MACHINE_RAM`      | `<int>` | RAM to allocate per machine (in Mb) | 2048                                        |
| `VSPHERE_ROOT_VOLUME_SIZE` | `<int>` | Root disk size (in Gb)              | 20                                          |
| `VSPHERE_SSH_USER`         | `<str>` | SSH user                            | ubuntu                                      |
| `VSPHERE_SSH_PUBKEY`       | `<str>` | SSH pubkey                          | ubuntu (should be changed if access needed) |

### test_create_gcp_clusterdeployment.py
This test creates GCP standalone clusterdeployment

#### Variables that MUST be filled before run and have no default value
> **_NOTE:_** On this step it's expected to have file with generated google auth (json format)

| ENV Variable               | Type    | Desctiption                                                             |
|----------------------------|---------|-------------------------------------------------------------------------|
| `GCP_PROJECT_ID`           | `<str>` | `project_id` key in the received json                                   |
| `GCP_PRIVATE_KEY_ID`       | `<str>` | `private_key_id` key in the received json                               |
| `GCP_PRIVATE_KEY`          | `<str>` | `private_key` in exact format as in json (with control symbols like \n) |
| `GCP_CLIENT_EMAIL`         | `<str>` | `client_email` key in the received json                                 |
| `GCP_CLIENT_ID`            | `<str>` | `client_id` in the received json                                        |
| `GCP_CLIENT_X509_CERT_URI` | `<str>` | `client_x509_cert_url` in the received json.                            |
| `GCP_NETWORK_NAME`         | `<str>` | Network name which were created (usually in auto mode with gcloud)      |

#### Optional variables to customise the deployment
| ENV Variable                      | Type    | Desctiption                                                                                                                                        | Defaults                                                                 |
|-----------------------------------|---------|----------------------------------------------------------------------------------------------------------------------------------------------------|--------------------------------------------------------------------------|
| `GCP_AUTH_URI`                    | `<str>` | GCP auth uri. Can be obtained in corresponding field in the received json, but usually it's common for everyone                                    | "https://accounts.google.com/o/oauth2/auth"                              |
| `GCP_TOKEN_URI`                   | `<str>` | GCP token uri. Can be obtained in corresponding field in the received json, but usually it's common for everyone                                   | "https://oauth2.googleapis.com/token"                                    |
| `GCP_AUTH_PROVIDER_X509_CERT_URI` | `<str>` | GCP certs uri. Can be obtained in corresponding field in the received json, but usually it's common for everyone                                   | "https://www.googleapis.com/oauth2/v1/certs"                             |
| `GCP_UNIVERCE_DOMAIN`             | `<str>` | The universe domain used by the client instance. Can be obtained in corresponding field in the received json, but usually it's common for everyone | googleapis.com                                                           |
| `GCP_REGION`                      | `<str>` | Region to deploy to                                                                                                                                | europe-west4                                                             |
| `GCP_CP_MACHINE_TYPE`             | `<str>` | Control plane machine type                                                                                                                         | n2d-standard-2                                                           |
| `GCP_WORKER_MACHINE_TYPE`         | `<str>` | Worker machine type                                                                                                                                | Equals to `GCP_CP_MACHINE_TYPE`                                          |
| `GCP_CP_IMAGE`                    | `<str>` | Control plane image                                                                                                                                | projects/ubuntu-os-cloud/global/images/ubuntu-2404-noble-amd64-v20250409 |
| `GCP_WRK_IMAGE`                   | `<str>` | Worker image                                                                                                                                       | Equals to `GCP_CP_IMAGE`                                                 |


## Hosted clsuters

### Common parameters for hosted clusters (except vSphere hosted)

#### Variables that MUST be filled before run and have no default value

| ENV Variable                 | Type    | Desctiption                                              |
|------------------------------|---------|----------------------------------------------------------|
| `KSI_HOST_CLUSTER_NAME`      | `<str>` | Cluster name where hosted deployment is gonna be created |
| `KSI_HOST_CLUSTER_NAMESPACE` | `<str>` | Cluster namespace where host cluster lives               |


#### Common and useful information
- Control plane nodes count (`KCM_CLUSTER_CONTROLPLANE_NUMBER`) is not available for this type of deployment.
- Worker nodes (`KCM_CLUSTER_WORKERS_NUMBER`) can be adjusted as usual.

![Schematic overview](../../../docs/images/ksi-hosted-clusters.svg)

#### Step-by-step example of the common workflow

1. Assuming that user have the initial kcm cluster deployed by the hand or by the test ([test_install_kcm.py](../bootstrap/README.md#bootstrap-test-module))
2. Set the required parameters for the usual deployment and execute the corresponding standalone clusterdeployment test:
```shell
export KUBECONFIG=my-shiny-kcm-cluster-kubeconfig
export KCM_CLUSTER_WORKERS_NUMBER=1
export KCM_CLUSTER_DEPLOYMENT_NAME=va4st-ksi-provider-specific-mothership-1
export KCM_CLUSTER_CONTROLPLANE_NUMBER=1
```
Do not forget to set extended flavors for mothership cluster.
For example, in OpenStack provider it will be `OS_WRK_MACHINE_FLAVOR=m1.xlarge`. This flavor have 

3. Run the clusterdeployment and wait for readiness
```shell
py.test $(KSI_HOME)/si_tests/tests/clusterdeployments/test_create_<provider>_clusterdeployment.py
```

4. Kubeconfig will be saved in
```shell
$(KSI_HOME)/artifacts/va4st-ksi-provider-specific-mothership-1-kubeconfig
```

5. Export new KUBECONFIG and execute kcm install test ([test_install_kcm.py](../bootstrap/README.md#bootstrap-test-module)):
```shell
export KUBECONFIG=$(KSI_HOME)/artifacts/va4st-ksi-provider-specific-mothership-1-kubeconfig
export KCM_CHART_VERSION=1.1.0
py.test $(KSI_HOME)/si_tests/tests/bootstrap/test_install_kcm.py
```

6. When kcm installation will be finished - update your variables to avoid crossing with standalone deployment and export initial KUBECONFIG back.
Also add the required variables for the hosted deployment:
```shell
export KUBECONFIG=my-shiny-kcm-cluster-kubeconfig
export KCM_CLUSTER_WORKERS_NUMBER=1
export KCM_CLUSTER_DEPLOYMENT_NAME=va4st-ksi-provider-specific-hosted-1
export KSI_HOST_CLUSTER_NAME=va4st-ksi-provider-specific-mothership-1
export KSI_HOST_CLUSTER_NAMESPACE=kcm-system
```

7. Execute the hosted deployment test and wait for the completion
```shell
py.test $(KSI_HOME)/si_tests/tests/clusterdeployments/test_create_<provider>_hosted_clusterdeployment.py
```



### test_create_os_hosted_clusterdeployment.py
This test creates OpenStack hosted clusterdeployment

> **_IMPORTANT:_** Please make sure, that the same cloud credentials is used for both management and hosted clusters.
#### Variables that MUST be filled before run and have no default value
| ENV Variable                       | Type    | Desctiption                                                                                                                      |
|------------------------------------|---------|----------------------------------------------------------------------------------------------------------------------------------|
| `OS_APPLICATION_CREDENTIAL_ID`     | `<str>` | OpenStack Application Credential ID (can be obtaining by creating application credential via settings page inside OpenStack)     |
| `OS_APPLICATION_CREDENTIAL_SECRET` | `<str>` | OpenStack Application Credential Secret (can be obtaining by creating application credential via settings page inside OpenStack) |

#### Optional variables to customise the deployment
| ENV Variable              | Type    | Desctiption                                                                                            | Defaults                                 |
|---------------------------|---------|--------------------------------------------------------------------------------------------------------|------------------------------------------|
| `OS_AUTH_URL`             | `<str>` | OpenStack Keystone URL                                                                                 | https://keystone.ic-eu.ssl.mirantis.net/ |
| `OS_REGION_NAME`          | `<str>` | OpenStack Region                                                                                       | RegionOne                                |
| `OS_INTERFACE`            | `<str>` | Public interface to connect network during deployment process                                          | public                                   |
| `OS_IDENTITY_API_VERSION` | `<str>` | OpenStack Keystone Identity API version                                                                | 3                                        |
| `OS_AUTH_TYPE`            | `<str>` | OpenStack Auth Type                                                                                    | v3applicationcredential                  |
| `OS_WRK_MACHINE_FLAVOR`   | `<str>` | OpenStack Flavor to deploy workers' machines                                                           | k8s_contrail.cid                         |
| `OS_INSTANCE_IMAGE_NAME`  | `<str>` | Image to be used for instance creation                                                                 | ubuntu-24.04-x86_64                      |
| `KSI_OS_SECURITY_GROUP`   | `<str>` | Security group to be used for created instances. Will disable creation of CAPI managed secutiry group. | None                                     |
| `KSI_OS_KEYPAIR_NAME`     | `<str>` | Name of the keypair to assign to instance                                                              | None                                     |

#### Additional information
- The management (k8s cluster with kcm installed) should be located inside same OpenStack cluster and tenant as desired hosted cluster.
- The CP of hosted cluster will land into the worker nodes of the mgmt cluster, so recommended worker config for such type of deployment with `KCM_CLUSTER_WORKERS_NUMBER=1` is
  `OS_WRK_MACHINE_FLAVOR=m1.xlarge`.

### test_create_vsphere_hosted_clusterdeployment.py
This test creates vSphere hosted clusterdeployment

#### Additional information
- The management (k8s cluster with kcm installed) should be located inside same vCenter. The easiest way to get such cluster is
  to deploy cluster using vSphere standalone cluster template.
- The CP of hosted cluster will land into the worker nodes of the mgmt cluster, so recommended worker config for such type of deployment is
  `VSPHERE_MACHINE_CPU=8` and `VSPHERE_MACHINE_RAM=8192`.

#### Variables that MUST be filled before run and have no default value (vSphere hosted)
| ENV Variable                        | Type    | Desctiption                                                         |
|-------------------------------------|---------|---------------------------------------------------------------------|
| `VSPHERE_SERVER_ADDR`               | `<str>` | vSphere vCenter address                                             |
| `VSPHERE_DATACENTER_NAME`           | `<str>` | Name of vSphere vCenter                                             |
| `VSPHERE_DATASTORE_PATH`            | `<str>` | Path to datastore                                                   |
| `VSPHERE_USER`                      | `<str>` | vSphere user                                                        |
| `VSPHERE_PASSWORD`                  | `<str>` | vSphere password                                                    |
| `VSPHERE_NETWORK_PATH`              | `<str>` | Network path                                                        |
| `VSPHERE_VM_TEMPLATE_PATH`          | `<str>` | VM template path (image analogue)                                   |
| `VSPHERE_RESOURCE_POOL_PATH`        | `<str>` | Resource path of vSphere                                            |
| `VSPHERE_FOLDER_PATH`               | `<str>` | vSphere folder (usually user folder to store vms)                   |
| `VSPHERE_CONTROL_PLANE_ENDPOINT_IP` | `<str>` | Manually (so far) discovered suitable IP from pool to make endpoint |

#### Optional variables to customise the deployment
| ENV Variable               | Type    | Desctiption                         | Defaults                                    |
|----------------------------|---------|-------------------------------------|---------------------------------------------|
| `VSPHERE_MACHINE_CPU`      | `<int>` | CPU to allocate per machine         | 2                                           |
| `VSPHERE_MACHINE_RAM`      | `<int>` | RAM to allocate per machine (in Mb) | 2048                                        |
| `VSPHERE_ROOT_VOLUME_SIZE` | `<int>` | Root disk size (in Gb)              | 20                                          |
| `VSPHERE_SSH_USER`         | `<str>` | SSH user                            | ubuntu                                      |
| `VSPHERE_SSH_PUBKEY`       | `<str>` | SSH pubkey                          | ubuntu (should be changed if access needed) |

#### Step-by-step example of the workflow

1. Assuming that user have the initial kcm cluster deployed by the hand or by the test ([test_install_kcm.py](../bootstrap/README.md#bootstrap-test-module))
2. Set the required parameters for the vSphere standalone cluster deployment:
```shell
export KUBECONFIG=my-shiny-kcm-cluster-kubeconfig
export VSPHERE_MACHINE_CPU=8
export VSPHERE_MACHINE_RAM=8192
export KCM_CLUSTER_CONTROLPLANE_NUMBER=1
export KCM_CLUSTER_WORKERS_NUMBER=1
export KCM_CLUSTER_DEPLOYMENT_NAME=va4st-ksi-vshpere-mothership-1
```
Use unique and not-occupied vSphere IP
```shell
export VSPHERE_CONTROL_PLANE_ENDPOINT_IP=172.16.40.161
```
Do not forget to fill auth [configuration](#variables-that-must-be-filled-before-run-and-have-no-default-value-vsphere-hosted)

3. Run the clusterdeployment and wait for readiness
```shell
py.test $(KSI_HOME)/si_tests/tests/clusterdeployments/test_create_vsphere_clusterdeployment.py
```
4. Kubeconfig will be saved in
```shell
$(KSI_HOME)/artifacts/va4st-ksi-vshpere-mothership-1-kubeconfig
```
5. Export new KUBECONFIG and execute kcm install test ([test_install_kcm.py](../bootstrap/README.md#bootstrap-test-module)):
```shell
export KUBECONFIG=$(KSI_HOME)/artifacts/va4st-ksi-vshpere-mothership-1-kubeconfig
export KCM_CHART_VERSION=1.1.0
py.test $(KSI_HOME)/si_tests/tests/bootstrap/test_install_kcm.py
```
6. When kcm installation will be finished - update your variables to avoid crossing with standalone deployment:
```shell
export VSPHERE_MACHINE_CPU=1
export VSPHERE_MACHINE_RAM=2048
export KCM_CLUSTER_WORKERS_NUMBER=1
export KCM_CLUSTER_DEPLOYMENT_NAME=va4st-ksi-vshpere-hosted-1
```
Verify that this address is unique and not occupied. It should be different and not match address in a step 2.
```shell
export VSPHERE_CONTROL_PLANE_ENDPOINT_IP=172.16.40.189
```
Auth variables should be the same
7. Execute the vSphere hosted test and wait for the completion
```shell
py.test $(KSI_HOME)/si_tests/tests/clusterdeployments/test_create_vsphere_hosted_clusterdeployment.py
```

### Cleaning up the hosted deployments and kcm
1. The most important thing - to not forget about hosted deployment and clean it up before standalone deployment will be removed because if you're lost access to the standalone deployment -
   it will not possible properly remove the virtual machines and resources.
   So first of all - remove the hosted deployment:
```shell
export KUBECONFIG=$(KSI_HOME)/artifacts/va4st-ksi-mothership-1-kubeconfig
export KCM_CLUSTER_DEPLOYMENT_NAME=va4st-ksi-hosted-1
py.test $(KSI_HOME)/si_tests/tests/clusterdeployments/test_delete_clusterdeployment.py
```
2. Right after the hosted deployment is removed - feel free to remove everything using cleanup test ([test_cleanup_kcm.py](../bootstrap/README.md#cleanup-test_cleanup_kcmpy))
```shell
export KUBECONFIG=my-shiny-kcm-cluster-kubeconfig
py.test $(KSI_HOME)/si_tests/tests/bootstrap/test_cleanup_kcm.py
```

## Regional clusters

### Common regional parameters

| ENV Variable           | Type    | Desctiption                                                                                                                                                                | Defaults                   |
|------------------------|---------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------------------------|
| `KSI_KOF_MGMT_STORAGE` | `<str>` | kof-collectors config that represents where the management data will be stored. Will enable collectors install after regional cluster setup. Choises: regional, management | management                 |
| `KSI_REGION_NAME`      | `<str>` | Regional identificator for deployment. Will be passed to the clusterconfig as 'region' parameter                                                                           | region-one                 |
| `KSI_KOF_EMAIL`        | `<str>` | e-mail needed for creating certificate (letsencrypt). Not used for now because self-signed certs for storage is default and not configurable value in ksi                  | the_mighty_qa@mirantis.com |

### test_create_os_regional_clusterdeployment.py
This test creates OpenStack standalone clusterdeployment with regional kof role.

Test actually have the same flow for deployment as [test_create_os_clusterdeployment.py](#test_create_os_clusterdeploymentpy)
but have different configuration specifics, related to kof and its deployment config.

> **_NOTE:_** Most of these variables can be obtained by downloading openstack-rc file after creation of OS Application ID.

#### Variables that MUST be filled before run and have no default value
| ENV Variable                       | Type    | Desctiption                                                                                                                      |
|------------------------------------|---------|----------------------------------------------------------------------------------------------------------------------------------|
| `OS_APPLICATION_CREDENTIAL_ID`     | `<str>` | OpenStack Application Credential ID (can be obtaining by creating application credential via settings page inside OpenStack)     |
| `OS_APPLICATION_CREDENTIAL_SECRET` | `<str>` | OpenStack Application Credential Secret (can be obtaining by creating application credential via settings page inside OpenStack) |

#### Optional variables to customise the deployment
| ENV Variable              | Type    | Desctiption                                                                                            | Defaults                                 |
|---------------------------|---------|--------------------------------------------------------------------------------------------------------|------------------------------------------|
| `OS_AUTH_URL`             | `<str>` | OpenStack Keystone URL                                                                                 | https://keystone.ic-eu.ssl.mirantis.net/ |
| `OS_REGION_NAME`          | `<str>` | OpenStack Region                                                                                       | RegionOne                                |
| `OS_INTERFACE`            | `<str>` | Public interface to connect network during deployment process                                          | public                                   |
| `OS_IDENTITY_API_VERSION` | `<str>` | OpenStack Keystone Identity API version                                                                | 3                                        |
| `OS_AUTH_TYPE`            | `<str>` | OpenStack Auth Type                                                                                    | v3applicationcredential                  |
| `OS_CTL_MACHINE_FLAVOR`   | `<str>` | OpenStack Flavor to deploy control plane machines                                                      | cfg.dev                                  |
| `OS_WRK_MACHINE_FLAVOR`   | `<str>` | OpenStack Flavor to deploy workers' machines                                                           | k8s_contrail.cid                         |
| `OS_INSTANCE_IMAGE_NAME`  | `<str>` | Image to be used for instance creation                                                                 | ubuntu-24.04-x86_64                      |
| `KSI_OS_SECURITY_GROUP`   | `<str>` | Security group to be used for created instances. Will disable creation of CAPI managed secutiry group. | ubuntu-24.04-x86_64                      |
| `KSI_OS_KEYPAIR_NAME`     | `<str>` | Name of the keypair to assign to instance                                                              |                                          |

## Cluster removal test (test_delete_clusterdeployment.py)
Test to delete the clusterdeployment.
Along with syncronious check of resource removal it verifies that infrastructure resource (AWSCluster, VSphereCluster, etc) was also removed.

#### Variables that MUST be inspected before run and have default value
| ENV Variable       | Type    | Desctiption                        | Defaults                               |
|--------------------|---------|------------------------------------|----------------------------------------|
| `TARGET_CLD`       | `<str>` | Target clusterdeployment name      | Equals to `KCM_CLUSTERDEPLOYMENT_NAME` |
| `TARGET_NAMESPACE` | `<str>` | Target clusterdeployment namespace | `          kcm-system`                 |

## Add Custom ClusterTemplate (test_add_clustertemplate.py)
Test to create an extra ClusterTemplate from the specified helm chart, if some customization 

#### Variables that MUST be filled before run and have no default value
| ENV Variable                       | Type    | Desctiption                                                           |
|------------------------------------|---------|-----------------------------------------------------------------------|
| `KCM_CLUSTER_DEPLOYMENT_NAMESPACE` | `<str>` | Target clustertemplate namespace                                      |
| `CUSTOM_CLUSTERTEMPLATE_PATH`      | `<str>` | Path to the ClusterTemplate yaml file (will be rendered using Jinja2) |

#### Optional variables to customise the deployment
You can use any environment variables inside the file specified in <CUSTOM_CLUSTERTEMPLATE_PATH>, using {{ os_env('<env var name>', '<default value>') }}
Example "templates/deploy-objects/clustertemplates/default/clustertemplate.yaml" uses the following variables:

| ENV Variable                                 | Type    | Desctiption                                            | Defaults                       |
|----------------------------------------------|---------|--------------------------------------------------------|--------------------------------|
| `KCM_CLUSTER_TEMPLATE_NAME`                  | `<str>` | Name of the creating ClusterTemplate                   | "demo"                         |
| `CUSTOM_CLUSTERTEMPLATE_HELM_CHART_NAME`     | `<str>` | Helm chart name for the ClusterTemplate                | "aws-standalone-cp"            |
| `CUSTOM_CLUSTERTEMPLATE_HELM_CHART_VERSION`  | `<str>` | Helm chart version for the ClusterTemplate             | "0.2.0"                        |
| `CUSTOM_HELM_REPOSITORY_NAME`                | `<str>` | Helm repository name, where to get the chart           | "kcm-templates"                |
| `CUSTOM_HELM_REPOSITORY_NAMESPACE`           | `<str>` | Helm repository namespace, where to get the chart      | "kcm-system"                   |
