#    Copyright 2022 Mirantis, Inc.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations


from si_tests.clients.k8s.base import K8sClusterScopedResource
from si_tests.clients.k8s.base import K8sBaseManager
from si_tests import logger

LOG = logger.logger


class K8sStorageClass(K8sClusterScopedResource):
    resource_type = 'storageclass'

    def _read(self, **kwargs):
        return self._manager.api.read_storage_class(self.name, **kwargs)

    def _create(self, body, **kwargs):
        return self._manager.api.create_storage_class(self.name, body, **kwargs)

    def _patch(self, body, **kwargs):
        return self._manager.api.patch_storage_class(self.name, body, **kwargs)

    def _replace(self, body, **kwargs):
        return self._manager.api.replace_storage_class(self.name, body, **kwargs)

    def _delete(self, **kwargs):
        self._manager.api.delete_storage_class(self.name, **kwargs)

    @property
    def is_default(self):
        annotations = self.data['metadata'].get('annotations', {})
        return annotations.get('storageclass.kubernetes.io/is-default-class', 'false') == 'true'

    def make_default(self):
        LOG.info(f"Set StorageClass {self.name} default")
        if not self.is_default:
            body = {'metadata': {'annotations': {}}}
            if 'annotations' in self.data['metadata'].keys():
                body['metadata']['annotations'] = self.data['metadata']['annotations']
            body['metadata']['annotations']['storageclass.kubernetes.io/is-default-class'] = 'true'
            self.patch(body)


class K8sStorageClassManager(K8sBaseManager):
    resource_class = K8sStorageClass

    @property
    def api(self):
        return self._cluster.api_storage

    def _list(self, **kwargs):
        return self.api.list_storage_class(**kwargs)

    def _list_all(self, **kwargs):
        return self._list(**kwargs)
