# V1SqsTrigger

Sqs trigger configuration

## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**activation_queue_length** | **int** | ActivationQueueLength is the length of the queue at which the trigger will be activated | [optional] 
**aws_endpoint** | **str** | AwsEndpoint Endpoint URL to override the default AWS endpoint | [optional] 
**aws_region** | **str** | AwsRegion is the region of the SQS queue | 
**queue_length** | **int** | QueueLength is the length of the queue that will be passed to scaler. In simple words it is number of items one pod can handle. | 
**queue_url** | **str** | QueueUrl is the URL of the SQS queue | 
**scale_on_delayed** | **bool** | ScaleOnDelayed indication of whether or not to include delayed messages when calculating the number of messages | [optional] 
**scale_on_flight** | **bool** | ScaleOnInFlight indication of whether or not to include in-flight messages when calculating the number of messages | [optional] 
**secret_name** | **str** | SecretName is the name of the authentication configuration CR | 

## Example

```python
from si_tests.clients.gcore.box_api.models.v1_sqs_trigger import V1SqsTrigger

# TODO update the JSON string below
json = "{}"
# create an instance of V1SqsTrigger from a JSON string
v1_sqs_trigger_instance = V1SqsTrigger.from_json(json)
# print the JSON string representation of the object
print(V1SqsTrigger.to_json())

# convert the object into a dict
v1_sqs_trigger_dict = v1_sqs_trigger_instance.to_dict()
# create an instance of V1SqsTrigger from a dict
v1_sqs_trigger_from_dict = V1SqsTrigger.from_dict(v1_sqs_trigger_dict)
```
[[Back to Model list]](../README.md#documentation-for-models) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to README]](../README.md)


