# Test environment using openstack heat backend

| :warning: WARNING                                                    |
|:---------------------------------------------------------------------|
| Current state of templates and logic around: PoC for internal usage. |
| Don't expect it would be easy to re-use out-of-the box               |
| Please refer to them, only like examples.                            |

## Current status:

Early WorkInProgress. This document briefly describes logic around:
- Heat Stack based envs
- How-to spawn heat stack(which test to be used)
- How-to run remote test execution

- TaskList:
* ✅ Integrate heat templates and heat stack spawn logic
* ✅ Integrate RemoteRunner into KSI
* ✔️ Integrate basic preparation at seed node(install base packages,etc.)
* ✅ Integrate k0rdent install to seed node
* ✅ Integration k0rdent-bm chart install

## Overview of idea

Integration tests for the k0rdent with physically separated underlay(VMs).
Basically, required to be able to prepare simplified, reproducible environment,
which able to perform installation, integration tests for k0rdent, using Virtual Machines
in openstack.

![Schematic overview](images/ksi-heat-env.png)

## Structure overview

```text
tree -L 3 test_env_data/
test_env_data/
├── heat
│ ├── chunks
│ │ ├── env1_group1.yaml
│ │ ├── .....
│ ├── env1_virtual_lab.hot
│ └── envs
│     └── env1_default.yaml
├── ic_access
│ └── clouds.yaml
├── labs
│ ├── os-virtual
│ │ └── heat_data
│ └── phys-487
└── README.md
```

`si_tests/test_env_data/heat` - folder with all required chunks and `.hot` templates for
openstack heat backend.
`si_tests/ic_access/clouds.yaml` - `clouds.yaml` template for access to openstack cloud backend.
Should be **extended for internal logic** ( see file for more info), **or override for custom env-run**
using `KSI_OS_CLOUDS_YAML_PATH`.
`si_tests/test_env_data/labs` - folder with actual `lab` environment configurations to run.

## Usage example

Absolute minimum example, to initiate heat stack creation at openstack, using local data:

# Stage1: spawn seed node and basic ksi_config

```bash
#!/usr/bin/env bash

set -x


export KSI_OS_CLOUDS_YAML_PATH="path/to/my/clouds.yaml"
#export KSI_KEEP_ENV_BEFORE='false
# cloud_name section from KSI_OS_CLOUDS_YAML_PATH
export KSI_OS_CLOUD_NAME="mycloud"
export ENV_NAME='username-ksi-test'
# refers to test_env_data/labs/os-virtual/
export KSI_ENV_CONFIG_NAME="os-virtual"
export ARTIFACTS_DIR="_temp/${env_name}/artifacts/"
mkdir -p ${ARTIFACTS_DIR}
# spawn basic ksi_config
export KSI_SEED_SSH_PRIV_KEY_FILE='id_ed_ksiuser' # or any other key, which included into heat templates
ksi-runtest config-create  > "${ARTIFACTS_DIR}/ksi_config.yaml"
export KSI_CONFIG_PATH="${ARTIFACTS_DIR}/ksi_config.yaml"

py.test --color=yes --junit-xml=${ARTIFACTS_DIR}/tests_report.xml si_tests/tests/infra/openstack/test_create_env.py
```

After test execution, operator will get alive stack, with floating seed ip, like:

```bash
$ cat "${ARTIFACTS_DIR}/ksi_config.yaml" |grep 
KSI_SEED_STANDALONE_EXTERNAL_IP: 172.19.124.173

```

openstack cli example:

```bash
$ OS_CLOUD=ic-eu-k0rdent-bm openstack stack list
+--------------------------------------+------------------------------------------+-----------------+----------------------+--------------+
| ID                                   | Stack Name                               | Stack Status    | Creation Time        | Updated Time |
+--------------------------------------+------------------------------------------+-----------------+----------------------+--------------+
| faf41f65-1e3e-4151-aabb-ff69c0ed9040 | username-ksi-test                        | CREATE_COMPLETE | 2025-04-28T13:42:41Z | None         |
$ OS_CLOUD=ic-eu-k0rdent-bm openstack stack show -f yaml username-ksi-test |grep 'output_key: seed_floating_ip' -A 1
output_key: seed_floating_ip
output_value: 172.19.124.173
```

# Stage2: run tests execution at seed node

```shell

set -x
# prepare test bins locally
if [ -f 'bin/kubectl' ]; then
  mkdir bin/
  curl -L "https://dl.k8s.io/release/$(curl -L -s https://dl.k8s.io/release/stable.txt)/bin/linux/amd64/kubectl" --output bin/kubectl
  curl -sSL https://get.helm.sh/helm-v3.17.3-linux-amd64.tar.gz | tar xz --strip-components=1 -C bin/ linux-amd64/helm
  chmod 0755 bin/*
fi

export ENV_NAME='username-ksi-test'
export KSI_RUN_ON_REMOTE='true' # this is required option, to exactly run on remote
export KSI_ENV_CONFIG_NAME="os-virtual"
export ARTIFACTS_DIR="_temp/${ENV_NAME}/artifacts/"
export KSI_CONFIG_PATH="${ARTIFACTS_DIR}/ksi_config.yaml"
# optional, use mirantis proxy in k0s, see k0s_manager.py:apply_registry_hack
#export KSI_K0S_APPLY_REGISTRY_HACK=true

R_TEST="si_tests/tests/bootstrap/test_install_seed_k0s_kcm.py"
ksi-runtest exec --config-path=${ARTIFACTS_DIR}/ksi_config.yaml '--command=py.test --color=yes --junit-xml=artifacts/tests_report.xml '${R_TEST}' 2>&1'

```

As you can observe from logs, `ksi-runtest` briefly:

1) Init connection via SSH, pre-install some pkgs\pip at remote node:
    ```
      KSI_SETUP_COMMAND: '[ -d ${KSI_SEED_VIRTUALENV} ] || ( sudo apt update; sudo apt-get
        install -y python3 python3-virtualenv virtualenv; virtualenv -p python3 ${KSI_SEED_VIRTUALENV});
        ${KSI_SEED_VIRTUALENV}/bin/pip install -r si_tests/requirements.txt; '
    ```
2) Sync all data from current dir, to remote workspace `KSI_SEED_UPLOAD_DIRS: .:.`, create by default at
   `/var/lib/ksi-tests/workspace_ksiuser_20250507_21_44_23`, using username `KSI_SEED_SSH_LOGIN: ksiuser`
3) Dump to remote node current process env, to `/var/lib/ksi-tests/workspace_ksiuser_20250507_21_44_23/.env-si-test`
4) Load on target node `.env-si-test`, and execute requested `.py` test
5) After test completes, sync back from seed folders `KSI_SEED_DOWNLOAD_DIRS: artifacts:artifacts`

# How-to debug failed remote tests?

Fastest way, to login into seed node and observe full env at base path:

```shell
 ls -alh /var/lib/ksi-tests/
drwxr-xr-x  2 ksiuser ksiuser 4.0K May  9 12:15 .states
drwxrwxr-x  5 ksiuser ksiuser 4.0K May  9 12:43 ksi-venv # used py-virtualenv
drwxrwxr-x 12 ksiuser ksiuser 4.0K May 13 10:53 workspace_ksiuser_20250509_15_42_34 # whole state of ksi-tests for test
```

You may activate venv, including all ENV state, and run locally any tests:

```shell
source /var/lib/ksi-tests/ksi-venv/bin/activate
cd /var/lib/ksi-tests/workspace_ksiuser_20250509_15_42_34
source .env-si-test
py.test --color=yes --junit-xml=artifacts/tests_report.xml si_tests/tests/bootstrap/test_install_seed_k0s_kcm.py
```
