#    Copyright 2022 Mirantis, Inc.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.
from si_tests import logger
from si_tests import settings
from si_tests.managers import bootstrap_manager

LOG = logger.logger


class TestSetupBaremetalEnvBV2():
    def test_setup_bm_env_bv2(self, show_step) -> None:
        """Bootstrap V2: setup seed node, env and ansible for BM deployment

         Scenario:
             1. ...
             2. ...
             3. ...
             4. Ansible and templates preparation on seed node
             5. Generate keycloak users data
         """

        bootstrap = bootstrap_manager.BootstrapManager.get_si_config_bootstrap_manager()
        show_step(3)
        bootstrap.step_003_prepare_bm_seed_node()

        env_config_name = bootstrap.bm_determine_env_config_name()
        # step 004: Ansible and templates preparation on seed node
        bootstrap.step_004_prepare_for_kaas_bm_cluster()
        if "virtual" in env_config_name:
            # Includes virtual and half-virtual envs
            bootstrap.step_004_prepare_bm_on_seed()
        else:
            bootstrap.step_004_prepare_bm_physical_on_seed(env_config_name)

        if settings.SKIP_BOOTSTRAP_TEMPLATES_CHECK:
            LOG.warning("Skip bootstrap templates check due "
                        "SKIP_BOOTSTRAP_TEMPLATES_CHECK flag is set")
            if not settings.KAAS_CUSTOM_LMA_LOGGING_ENABLED:
                bootstrap.disable_lma_logging()
            if settings.CORE_KEYCLOAK_LDAP_ENABLED:
                bootstrap.enable_keycloak_ldap()
        else:
            LOG.info("Checking bootstrap templates")
            bootstrap.check_templates()

        # step 006: Generate keycloak users data
        show_step(5)
        bootstrap.add_credentials_data_to_si_config()
