import importlib
import sys
from unittest import mock

import pytest

from si_tests import logger
from si_tests import settings
from si_tests import settings_func

LOG = logger.logger

# known to be internal and funcs
skip_list_built = [
    '__builtins__', '__cached__', '__doc__', '__file__', '__loader__', '__name__', '__package__', '__spec__', 'os',
    'resources', 'settings_func'
]

# TODO: global-refactor required
#  we currently far away from begin, so lets skip already used everywhere vars
skip_list = skip_list_built + [
    'ARTIFACTS_DIR',
    'AWS_ACCESS_KEY_ID',
    'AWS_DEFAULT_AZ',
    'AWS_DEFAULT_REGION',
    'AWS_ENABLED',
    'AWS_INSTANCE_AMI_CTL',
    'AWS_INSTANCE_AMI_WRK',
    'AWS_INSTANCE_ROOT_SIZE_CTL',
    'AWS_INSTANCE_ROOT_SIZE_WRK',
    'AWS_INSTANCE_TYPE_CTL',
    'AWS_INSTANCE_TYPE_WRK',
    'AWS_PROVIDER_NAME',
    'AWS_SECRET_ACCESS_KEY',
    'AZURE_CLIENT_ID',
    'AZURE_CLIENT_SECRET',
    'AZURE_CLUSTER_LOCATION',
    'AZURE_ENABLED',
    'AZURE_PROVIDER_NAME',
    'AZURE_SUBSCRIPTION_ID',
    'AZURE_TENANT_ID',
    'AZURE_VM_SIZE',
    'AZURE_VM_SIZE_CHILD',
    'AZURE_VM_SIZE_CTL',
    'AZURE_VM_SIZE_WRK',
    'CAPI_OPERATOR_APIVERSION',
    'CHECK_ACTUAL_EXPECTED_PODS_TIMEOUT',
    'CHECK_CLUSTER_READINESS_TIMEOUT',
    'CUSTOM_CLUSTERDEPLOYMENT_PATH',
    'CUSTOM_CLUSTERDEPLOYMENT_SERVICES_PATH',
    'CUSTOM_CLUSTERSERVICE_NAME',
    'CUSTOM_CLUSTERSERVICE_NAMESPACE',
    'CUSTOM_CLUSTERTEMPLATE_PATH',
    'CUSTOM_HELM_REPOSITORY_OVERWRITE',
    'CUSTOM_HELM_REPOSITORY_SECRET_TEMPLATE_PATH',
    'CUSTOM_HELM_REPOSITORY_TEMPLATE_PATH',
    'CUSTOM_SERVICETEMPLATE_PATH',
    'CUSTOM_SERVICETEMPLATE_VALUES_PATH',
    'EKS_PROVIDER_NAME',
    'EKS_SSH_KEY_NAME',
    'ENABLE_INTROSPECT_CAP_ERRORS',
    'ENV_NAME',
    'EXPECTED_PODS_TEMPLATES_DIR',
    'GCP_AUTH_PROVIDER_X509_CERT_URI',
    'GCP_AUTH_TYPE',
    'GCP_AUTH_URI',
    'GCP_CLIENT_EMAIL',
    'GCP_CLIENT_ID',
    'GCP_CLIENT_X509_CERT_URI',
    'GCP_CP_IMAGE',
    'GCP_CP_MACHINE_TYPE',
    'GCP_NETWORK_NAME',
    'GCP_PRIVATE_KEY',
    'GCP_PRIVATE_KEY_ID',
    'GCP_PROJECT_ID',
    'GCP_PROVIDER_NAME',
    'GCP_REGION',
    'GCP_TOKEN_URI',
    'GCP_UNIVERCE_DOMAIN',
    'GCP_WORKER_MACHINE_TYPE',
    'GCP_WRK_IMAGE',
    'GKE_CP_MACHINE_TYPE',
    'GKE_WORKER_MACHINE_TYPE',
    'K8S_CONFORMANCE_CHECK_RESULTS',
    'K8S_CONFORMANCE_CLUSTER_DOMAIN',
    'K8S_CONFORMANCE_DISABLE_OFFLINE_LOGIC',
    'K8S_CONFORMANCE_IMAGE',
    'K8S_CONFORMANCE_IMAGE_VERSION',
    'K8S_CONFORMANCE_IMAGE_VERSION_CHECK_PATH',
    'K8S_CONFORMANCE_NAMESPACE',
    'K8S_CONFORMANCE_NON_BLOCKING_TAINTS',
    'K8S_CONFORMANCE_POD_NAME',
    'K8S_CONFORMANCE_POD_YAML',
    'K8S_CONFORMANCE_REPORTS_DIR',
    'K8S_CONFORMANCE_RESULTS_WAIT_TIMEOUT',
    'K8S_CONFORMANCE_USER_DEFINED_SKIP_REGEX',
    'KCM_CHART_NAME',
    'KCM_CHART_VERSION',
    'KCM_CLUSTER_CONTROLPLANE_NUMBER',
    'KCM_CLUSTER_DEPLOYMENT_NAME',
    'KCM_CLUSTER_DEPLOYMENT_NAMESPACE',
    'KCM_CLUSTER_TEMPLATE_NAME',
    'KCM_CLUSTER_WORKERS_NUMBER',
    'KCM_CUSTOM_IMAGE_REPO',
    'KCM_CUSTOM_REGISTRY',
    'KCM_MANAGEMENT_NAME',
    'KCM_MANAGEMENT_NAME',
    'KCM_NAMESPACE',
    'KCM_REPO_DICT',
    'KCM_SERVICE_TEMPLATE_NAME',
    'KCM_SOURCE',
    'KUBECONFIG',
    'KUBECONFIG_PATH',
    'LOGS_DIR',
    'LOG_NAME',
    'LOG_REST_DEBUG',
    'MACHINE_PRIVELEGED_POD_YAML',
    'OPENSTACK_CTL_MACHINE_FLAVOR',
    'OPENSTACK_PROVIDER_NAME',
    'OS_APPLICATION_CREDENTIAL_ID',
    'OS_APPLICATION_CREDENTIAL_SECRET',
    'OS_AUTH_TYPE',
    'OS_AUTH_URL',
    'OS_CTL_MACHINE_FLAVOR',
    'OS_IDENTITY_API_VERSION',
    'OS_INSTANCE_IMAGE_NAME',
    'OS_INTERFACE',
    'OS_REGION_NAME',
    'OS_WRK_MACHINE_FLAVOR',
    'REMOVE_RESOURCES_ON_KCM_CLEANUP',
    'SERVICE_TEMPLATES_LIST',
    'SI_BINARIES_DIR',
    'SI_TESTS_REPO_ROOT',
    'SKIP_EXPECTED_POD_CHECK',
    'SVELTOS_NAMESPACE',
    'TARGET_CLD',
    'TARGET_CLDS',
    'TARGET_CLUSTERS',
    'TARGET_NAMESPACE',
    'VSPHERE_CIDR_EXCLUDE_RANGES',
    'VSPHERE_CIDR_INCLUDE_RANGES',
    'VSPHERE_CONTROL_PLANE_ENDPOINT_IP',
    'VSPHERE_DATACENTER_NAME',
    'VSPHERE_DATASTORE_PATH',
    'VSPHERE_ENABLED',
    'VSPHERE_FOLDER_PATH',
    'VSPHERE_MACHINE_CPU',
    'VSPHERE_MACHINE_RAM',
    'VSPHERE_NETWORK_CIDR',
    'VSPHERE_NETWORK_PATH',
    'VSPHERE_PASSWORD',
    'VSPHERE_PROVIDER_NAME',
    'VSPHERE_RESOURCE_POOL_PATH',
    'VSPHERE_ROOT_VOLUME_SIZE',
    'VSPHERE_SERVER_ADDR',
    'VSPHERE_SERVER_INSECURE',
    'VSPHERE_SSH_PUBKEY',
    'VSPHERE_SSH_USER',
    'VSPHERE_USER',
    'VSPHERE_VM_TEMPLATE_PATH',
    'WAIT_PODS_READY_TIMEOUT',
]

_doc_reference = ("Variables must start from `KSI_`.\n"
                  "Variables with 'secrets', starting from `KSI_SECRET_` must have no defaults.\n"
                  "Please check docs fore more info, "
                  "at https://github.com/k0rdent/ksi/blob/main/CONTRIBUTING.md#-repo-standards")


def test_settings_py_keys():
    """
    Filter and fail, if found in settings.py vars not be rule:
    - Should start with KSI_
    - Should be none, for secrets at KSI_SECRET_
    :return:
    """
    failed_keys = []
    bad_sensitive_keys = []
    LOG.info(f'Total settings.keys count:{len([i for i in vars(settings).keys() if i not in skip_list_built])}')
    bad_keys = [i for i in vars(settings).keys() if not i.startswith('KSI_') and not callable(i)]
    for k in bad_keys:
        if k in skip_list:
            continue
        # we hope, that no one adds new-lower-case vars
        if isinstance(k, str) and k.isupper():
            LOG.warning(f'bad key detected:{k}')
            failed_keys.append(k)
    # check for not posting secrets itself
    sensitive_keys = [i for i in vars(settings).keys() if i.startswith('KSI_SECRET_')]
    for k in sensitive_keys:
        if isinstance(k, str):
            # we always must be none
            if getattr(settings, k):
                LOG.warning(f'bad secret key detected:{k}')
                bad_sensitive_keys.append(k)
    # Combine, just to have more readable fail in case multiply issues detected.
    if len(failed_keys) >= 1 or len(bad_sensitive_keys) >= 1:
        pytest.fail(f'Found bad keys at settings.py :\n{failed_keys}\n'
                    f'Found bad secrets at settings.py :\n{bad_sensitive_keys}\n'
                    f'{_doc_reference}')


def test_settings_py_envs():
    """
    This test mock funcs around settings.py
    and try to test exactly referenced os.env naming

    """
    # Ensure the module is not already loaded
    sys.modules.pop("settings", None)
    used_envvars = set()
    failed_keys = []

    def my_get_var(name, default=""):
        used_envvars.add(name)
        return default

    def my_get_var_as_bool(name, default):
        used_envvars.add(name)
        return default

    def my_get_var_from_json(name, default="{}"):
        used_envvars.add(name)
        return default

    def my_get_path(name, default):
        used_envvars.add(name)
        return default

    # TODO(alexz-kh): we need somehow detect new functions around
    with mock.patch.object(settings_func, "get_var", side_effect=my_get_var) as _, \
            mock.patch.object(settings_func, "get_var_as_bool", side_effect=my_get_var_as_bool) as _, \
            mock.patch.object(settings_func, "get_var_from_json", side_effect=my_get_var_from_json) as _, \
            mock.patch.object(settings_func, "get_path", side_effect=my_get_path) as _:
        importlib.reload(settings)
        LOG.info(f'Total settings[os.env].references count:'
                 f'{len([i for i in used_envvars if i not in skip_list_built])}')

        bad_keys = [i for i in used_envvars if not i.startswith('KSI_') and not callable(i)]
        for k in bad_keys:
            if k in skip_list:
                continue
            LOG.warning(f'bad key detected:{k}')
            failed_keys.append(k)
        # Combine, just to have more readable fail in case multiply issues detected.
        if len(failed_keys) >= 1:
            pytest.fail(f'Found bad os.env references at settings.py:\n{failed_keys}'
                        f'\n{_doc_reference}')
    # reload once more after mock test, just to be on safe side.
    importlib.reload(settings)
