import pytest

from si_tests import settings
import yaml
from si_tests import logger
from si_tests.utils import templates
from si_tests.clients.openstack import OpenstackClient

LOG = logger.logger


@pytest.fixture(scope='session')
def openstack_client():
    cloud_name = settings.KSI_OS_CLOUD_NAME
    cloud_yaml_file = settings.KSI_OS_CLOUDS_YAML_PATH
    clouds_yaml = yaml.load(templates.render_template(cloud_yaml_file), Loader=yaml.SafeLoader)
    LOG.debug(f'Using >{cloud_name}< from {cloud_yaml_file}')
    auth = clouds_yaml["clouds"][cloud_name]

    client = OpenstackClient(auth)
    return client
