# coding: utf-8

"""
    Inference Box API

    ## Welcome to Inference Box API  A comprehensive REST API for managing cloud infrastructure resources including ML inference deployments, Kubernetes resources, and application lifecycle management.  ## Overview  Inference Box API is a cloud-native REST API service that provides unified access to manage:  - **ML Inference Deployments**: Create, manage, and scale machine learning inference services - **Slurm Clusters**: Deploy, configure, and manage HPC Slurm clusters for batch workloads - **Kubernetes Resources**: Manage namespaces (projects), pods, secrets, volumes, and other K8s resources - **Application Lifecycle**: Deploy and manage applications from catalog templates - **Resource Management**: Handle flavors, capacities, quotas, and node groups - **User & Access Control**: Manage users, groups, and API keys with RBAC integration - **Monitoring & Metrics**: Query metrics and monitor resource usage via Victoria Metrics  The service is built with Go and integrates with Kubernetes, HashiCorp Vault, and Victoria Metrics to provide a complete cloud infrastructure management solution.  ## Key API Endpoints  - **Inference**: `/v1/{project_name}/inferences` - ML inference deployment management - **Slurm Clusters**: `/v1/{project_name}/slurm/clusters` - Slurm cluster deployment and management - **Flavors**: `/v1/flavors` - Compute resource flavor definitions - **Users**: `/v1/admin/users` - User management (admin only) - **Projects**: `/v1/{project_name}` - Project-scoped resource operations - **Metrics**: `/v1/{project_name}/metrics` - Resource usage metrics  ## Getting Started  ### Authentication  All API requests require authentication using the `X-API-Key` header. Most operations are scoped to specific projects/namespaces.  ### API Organization  The API is organized into logical groups: - **Public endpoints**: `/v1/*` - General access endpoints - **Project-scoped**: `/v1/{project_name}/*` - Project-specific resources - **Admin endpoints**: `/v1/admin/*` - Administrative operations  ### Documentation  Interactive documentation is available at `/docs` when the service is running. 

    The version of the OpenAPI document: 2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from si_tests.clients.gcore.box_api.models.api_services_overview_v1_region import ApiServicesOverviewV1Region
from si_tests.clients.gcore.box_api.models.api_services_overview_v1_registry_response import ApiServicesOverviewV1RegistryResponse
from si_tests.clients.gcore.box_api.models.v1_cluster import V1Cluster
from si_tests.clients.gcore.box_api.models.v1_node import V1Node
from si_tests.clients.gcore.box_api.models.v1_volume_response import V1VolumeResponse
from typing import Optional, Set
from typing_extensions import Self

class V1OverviewResponse(BaseModel):
    """
    V1OverviewResponse
    """ # noqa: E501
    allocated_resources: Optional[Dict[str, StrictStr]] = Field(default=None, description="AllocatedResources contains the resources allocated in the installation")
    clusters: Optional[List[V1Cluster]] = Field(default=None, description="Clusters contains the list of clusters in the installation")
    nodes: Optional[List[V1Node]] = Field(default=None, description="Node contains the list of nodes in the installation")
    regions: Optional[List[ApiServicesOverviewV1Region]] = Field(default=None, description="NodeGroups contains the list of node groups in the installation")
    registries: Optional[List[ApiServicesOverviewV1RegistryResponse]] = Field(default=None, description="Registries contains the list of registries in the installation")
    registries_total: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="RegistriesTotal is the total size of all registries in the installation in GiB")
    registries_usage: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="RegistriesUsage is the usage of all registries in the installation in GiB")
    used_resources: Optional[Dict[str, StrictStr]] = Field(default=None, description="UsedResources contains the resources used in the installation")
    volumes: Optional[List[V1VolumeResponse]] = Field(default=None, description="Volumes contains the list of volumes in the installation")
    __properties: ClassVar[List[str]] = ["allocated_resources", "clusters", "nodes", "regions", "registries", "registries_total", "registries_usage", "used_resources", "volumes"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V1OverviewResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in clusters (list)
        _items = []
        if self.clusters:
            for _item_clusters in self.clusters:
                if _item_clusters:
                    _items.append(_item_clusters.to_dict())
            _dict['clusters'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in nodes (list)
        _items = []
        if self.nodes:
            for _item_nodes in self.nodes:
                if _item_nodes:
                    _items.append(_item_nodes.to_dict())
            _dict['nodes'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in regions (list)
        _items = []
        if self.regions:
            for _item_regions in self.regions:
                if _item_regions:
                    _items.append(_item_regions.to_dict())
            _dict['regions'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in registries (list)
        _items = []
        if self.registries:
            for _item_registries in self.registries:
                if _item_registries:
                    _items.append(_item_registries.to_dict())
            _dict['registries'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in volumes (list)
        _items = []
        if self.volumes:
            for _item_volumes in self.volumes:
                if _item_volumes:
                    _items.append(_item_volumes.to_dict())
            _dict['volumes'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V1OverviewResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "allocated_resources": obj.get("allocated_resources"),
            "clusters": [V1Cluster.from_dict(_item) for _item in obj["clusters"]] if obj.get("clusters") is not None else None,
            "nodes": [V1Node.from_dict(_item) for _item in obj["nodes"]] if obj.get("nodes") is not None else None,
            "regions": [ApiServicesOverviewV1Region.from_dict(_item) for _item in obj["regions"]] if obj.get("regions") is not None else None,
            "registries": [ApiServicesOverviewV1RegistryResponse.from_dict(_item) for _item in obj["registries"]] if obj.get("registries") is not None else None,
            "registries_total": obj.get("registries_total"),
            "registries_usage": obj.get("registries_usage"),
            "used_resources": obj.get("used_resources"),
            "volumes": [V1VolumeResponse.from_dict(_item) for _item in obj["volumes"]] if obj.get("volumes") is not None else None
        })
        return _obj


