import pytest
import yaml

from si_tests import logger
from si_tests import settings
from si_tests.utils import utils, templates

LOG = logger.logger

cluster_name = settings.TARGET_CLUSTER
namespace_name = settings.TARGET_NAMESPACE


def test_apply_irqbalance_conf(kaas_manager, show_step):
    """ Apply given irqbalance hoc on target machines
        Scenario:
            1. Check cluster state
            2. Enable irqbalance
            3. Check irqbalance config applied
            4. Check cluster state
        """

    ns = kaas_manager.get_namespace(namespace_name)
    cluster = ns.get_cluster(cluster_name)
    all_machines = cluster.get_machines()
    selected_machines = []
    for machine in all_machines:
        for label in settings.IRQBALANCE_NODE_LABELS:
            if label in machine.data['metadata']['labels'].keys():
                selected_machines.append(machine)
    if not selected_machines:
        msg = f"Skiipping test because no machines with labes {settings.IRQBALANCE_NODE_LABELS} exist"
        pytest.skip(msg)
    show_step(1)
    cluster.check.check_cluster_readiness()
    if cluster.provider is not utils.Provider.baremetal:
        pytest.skip(f"Cluster {cluster.name} provider is not a baremetal")
    cluster.check.check_cluster_readiness()
    hoc_data = yaml.safe_load(
        templates.render_template(settings.IRQBALANCE_HOC_FILE_PATH,
                                  options=dict(TARGET_CLUSTER=cluster_name, TARGET_NAMESPACE=namespace_name)))
    show_step(2)
    lcmmachines_timestamps_before = cluster.get_cluster_lcmmachines_timestamps()

    hoc_name = hoc_data['metadata']['name']
    if ns.hostosconfiguration_is_present(name=hoc_name):
        hostcfg = ns.get_hostosconfiguration(name=hoc_name)
        hostcfg.patch(hoc_data)
    else:
        hostcfg = ns.create_hostosconfiguration_raw(hoc_data)

    # Wait for the selected Machines in the hostosconfiguration status
    LOG.info("Check that machines from hostosconfiguration status field have labels used for machineSelector")
    cluster.check.check_hostosconfig_machine_selector(hostcfg)
    LOG.info("Check that new items added into machineTypes in LCMCluster")
    cluster.check.wait_lcmcluster_day2_machinetypes(hostcfg)
    LOG.info("Check that new items added into stateItems in LCMMachine")
    cluster.check.wait_lcmmachine_day2_stateitems(hostcfg, lcmmachines_timestamps_before)

    machines_full_names = [f"{m.namespace}/{m.name}" for m in selected_machines]
    show_step(3)
    cluster.check.check_day2_module_results('irqbalance', hostcfg, machines_full_names)
    LOG.info(f"IrqBalance succesfully applied on machine(s) with label(s) {settings.IRQBALANCE_NODE_LABELS}")
    show_step(4)
    cluster.check.check_cluster_readiness()
