import pytest

from si_tests import settings
from si_tests import logger

from si_tests.deployments import openstack_deploy


LOG = logger.logger


def test_deploy_helmbundle_controller(os_manager):
    timeout = settings.OPENSTACK_DEPLOY_SINGLE_TEST_TIMEOUT
    openstack_deploy.deploy_helmbundle_controller(os_manager, timeout)


def test_deploy_local_volume_provisioner(os_manager):
    timeout = settings.OPENSTACK_DEPLOY_SINGLE_TEST_TIMEOUT
    openstack_deploy.deploy_local_volume_provisioner(os_manager, timeout)


def test_deploy_metallb(os_manager):
    timeout = settings.OPENSTACK_DEPLOY_SINGLE_TEST_TIMEOUT
    openstack_deploy.deploy_metallb(os_manager, timeout)


def test_deploy_ceph_controller(os_manager):
    timeout = settings.OPENSTACK_DEPLOY_SINGLE_TEST_TIMEOUT
    openstack_deploy.deploy_ceph_controller(os_manager, timeout)


def test_deploy_ceph_cluster(os_manager):
    timeout = settings.OPENSTACK_DEPLOY_SINGLE_TEST_TIMEOUT
    openstack_deploy.deploy_ceph_cluster(os_manager, timeout)


@pytest.mark.skipif(not settings.OPENSTACK_DEPLOY_STACKLIGHT,
                    reason="Won't deploy stacklight")
def test_deploy_stacklight(os_manager):
    timeout = settings.OPENSTACK_DEPLOY_SINGLE_TEST_TIMEOUT
    openstack_deploy.deploy_stacklight(os_manager, timeout)


def test_deploy_openstack_controller(os_manager):
    timeout = settings.OPENSTACK_DEPLOY_SINGLE_TEST_TIMEOUT
    openstack_deploy.deploy_openstack_controller(os_manager, timeout)


@pytest.mark.skipif(not settings.OPENSTACK_DEPLOY_VAULT,
                    reason="Won't deploy vault")
def test_deploy_vault(os_manager):
    timeout = settings.OPENSTACK_DEPLOY_SINGLE_TEST_TIMEOUT
    openstack_deploy.deploy_vault(os_manager, timeout)


@pytest.mark.skipif(not settings.OPENSTACK_DEPLOY_IAM,
                    reason="Won't deploy IAM")
def test_deploy_iam(os_manager):
    timeout = settings.OPENSTACK_DEPLOY_SINGLE_TEST_TIMEOUT
    openstack_deploy.deploy_iam(os_manager, timeout)


def test_generate_ssl_certificates(os_manager):
    timeout = settings.OPENSTACK_DEPLOY_SINGLE_TEST_TIMEOUT
    openstack_deploy.generate_ssl_certificates(os_manager, timeout)


def test_deploy_openstack_cluster(os_manager):
    timeout = settings.OPENSTACK_DEPLOY_SINGLE_TEST_TIMEOUT
    openstack_deploy.deploy_openstack_cluster(os_manager, timeout)


def test_deploy_dns(os_manager):
    timeout = settings.OPENSTACK_DEPLOY_SINGLE_TEST_TIMEOUT
    openstack_deploy.deploy_dns(os_manager, timeout)


def test_configure_dns(os_manager):
    timeout = settings.OPENSTACK_DEPLOY_SINGLE_TEST_TIMEOUT
    openstack_deploy.configure_dns(os_manager, timeout)


def test_deploy_tungsten_fabric(os_manager):
    is_tf = openstack_deploy.is_tf_deployment()

    if not is_tf:
        msg = "Won't deploy tf, not tf deployment"
        LOG.warning(msg)
        pytest.skip(msg)

    timeout = settings.OPENSTACK_DEPLOY_SINGLE_TEST_TIMEOUT
    openstack_deploy.deploy_tungsten_fabric(os_manager, timeout)


def test_deploy_baremetal(os_manager):
    is_baremetal = openstack_deploy.is_baremetal()

    if not is_baremetal:
        msg = "Won't deploy ironic, not baremetal deployment"
        LOG.warning(msg)
        pytest.skip(msg)

    timeout = settings.OPENSTACK_DEPLOY_SINGLE_TEST_TIMEOUT
    openstack_deploy.deploy_vbmc(os_manager, timeout)
