from si_tests.deployments.utils import file_utils
from si_tests import settings
from si_tests import logger

LOG = logger.logger


def get_run_command(report_name, test_scheme=None):
    test_scheme_path = settings.OPENSTACK_TEST_SCHEME_PATH

    if test_scheme is None:
        test_scheme = file_utils.get_yaml_content(
            test_scheme_path, file_not_found_fail=False)

    if not test_scheme:
        return None

    cmd = ['pytest', '-v', '-s']

    if test_scheme.get("regex"):
        cmd.extend([f'stepler/horizon/{test_scheme.get("regex")}'])
        LOG.info(f"Running tests with regex: {test_scheme.get('regex')}")
    elif test_scheme.get("smoke"):
        cmd.extend(['stepler/horizon/', '-m', 'smoke'])
        LOG.info('Running smoke tests')
    elif test_scheme.get("markexpr"):
        cmd.extend(['stepler/horizon/', '-m', f'{test_scheme.get("markexpr")}'])
        LOG.info(f"Running tests matching following mark expression {test_scheme.get('markexpr')}")
    else:
        cmd.extend(["stepler/horizon/"])

    converted_keys = {
        'concurrency': '-n',
        "skip-file": "--skip-file"
    }

    for key in converted_keys.keys():
        if test_scheme.get(key):
            cmd.extend([converted_keys[key], str(test_scheme[key])])

    # Add saving of test results to pvc in command
    # If there are FAILED cases, stepler-test returns non-zero code.
    # pod CrashLoopBackOff -> run stepler tests again and again
    # without saving results.

    cmd.extend(
        [f"--junit-xml=/opt/stepler/test_reports/{report_name}||true"])

    return " ".join(cmd)
