Example:
```
- name: "Seed node preparation"
  hosts: seed_master
  gather_facts: true
  tags: configure
  roles:
    - micro_ipxe_provisioner
  vars:
    m_ipxe:
      http_addr: 10.0.1.1
      dnsmasq:
        other: |
          dhcp-option=option:dns-server,10.0.1.1
          dhcp-boot=tag:efi,tag:!ipxe,/ipxe.efi,10.0.1.1,10.0.1.1
          dhcp-boot=tag:ipxe,http://10.0.1.1/ipxe/,10.0.1.1
          dhcp-boot=/undionly.kpxe,10.0.1.1,10.0.1.1
          dhcp-range=10.0.1.31,10.0.1.40,255.255.255.0
          # gw
          dhcp-option=3,10.0.1.1
          dhcp-option=option:dns-server,172.19.80.70
      nodes:
        - name: cz1
          bootmacaddress: "52:54:15:41:0b:42"
          bmc_address: 0.0.0.0
          bmc_port: 6231
          bmc_login: admin
          bmc_password: r00tme
          target_netplan:
            version: 2
            ethernets:
              ens3:
                dhcp4: false
                addresses:
                  - 10.0.1.100/24
                gateway4: 10.0.1.1
                nameservers:
                  addresses:
                    - 172.19.80.70
                    - 8.8.8.8
                    - 1.1.1.1
        - name: cz2
          bootmacaddress: "52:54:16:33:cc:13"
          bmc_address: 0.0.0.0
          bmc_port: 6232
          bmc_login: admin
          bmc_password: r00tme
          target_netplan:
            version: 2
            ethernets:
              ens3:
                dhcp4: false
                addresses:
                  - 10.0.1.101/24
                gateway4: 10.0.1.1
                nameservers:
                  addresses:
                    - 172.19.80.70
                    - 8.8.8.8
                    - 1.1.1.1
```
