#    Copyright 2022 Mirantis, Inc.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations

from si_tests.clients.k8s import base


class V1KaaSVsphereResource(base.BaseModel):
    pass


class V1KaaSVsphereResourceList(base.BaseModelList):
    pass


class KaaSVsphereResource(base.K8sNamespacedResource):
    resource_type = 'vsphereresource'
    model = V1KaaSVsphereResource

    @property
    def regions(self):
        if 'regions' in self.data['status']:
            return self.data['status']['regions'].keys()

    def instance_types(self, region):
        if region in self.data['status']['regions'].keys():
            return self.data['status']['regions'][region]['instanceTypes']

    def images(self, region):
        if region in self.data['status']['regions'].keys():
            return self.data['status']['regions'][region]['AMIs']


class KaaSVsphereResourceManager(base.K8sBaseManager):
    model = V1KaaSVsphereResourceList
    resource_class = KaaSVsphereResource
    resource_group = 'kaas.mirantis.com'
    resource_version = 'v1alpha1'
    resource_plural = 'vsphereresources'
