import pytest
import os

from si_tests import settings
from si_tests import logger

LOG = logger.logger


@pytest.mark.parametrize("_", ["CLUSTER_NAME={0}"
                               .format(settings.KAAS_CHILD_CLUSTER_NAME)])
@pytest.mark.usefixtures("store_cluster_description")
@pytest.mark.usefixtures("introspect_child_deploy_objects")
def test_add_aws_node_single(kaas_manager, show_step, _):
    """Add single worker node to the child cluster."""

    # Collecting env data
    cluster_name = settings.KAAS_CHILD_CLUSTER_NAME
    namespace_name = settings.KAAS_NAMESPACE
    machine_image_name = settings.KAAS_CHILD_CLUSTER_MACHINE_IMAGE_NAME
    machine_flavor_name = settings.KAAS_CHILD_CLUSTER_MACHINE_FLAVOR_NAME
    machine_disk_type = settings.KAAS_CHILD_CLUSTER_MACHINE_AWS_DISK_TYPE

    # step 001 - Get namespace
    LOG.info("Namespace name - %s", namespace_name)
    ns = kaas_manager.get_namespace(namespace_name)
    cluster = ns.get_cluster(cluster_name)
    region = kaas_manager.get_mgmt_cluster().region_name

    # step 004 - Add 1 slave node
    slave_node = cluster.create_aws_machine(
        node_type="node",
        instance_type=machine_flavor_name,
        ami=machine_image_name,
        root_device_type=machine_disk_type,
        region=region)
    LOG.info('Added slave node {}'.format(slave_node))

    # Waiting for slave node become Ready
    cluster.check.wait_machine_status_by_name(machine_name=slave_node.name,
                                              expected_status='Ready')

    # Waiting for machines are Ready
    cluster.check.check_machines_status(timeout=1800)
    cluster.check.check_cluster_nodes()
    cluster.check.check_k8s_nodes()

    # Collecting artifacts
    LOG.info('Collecting artifacts from {} cluster'.format(cluster_name))
    cluster.store_k8s_artifacts()

    # Store node name
    name_path = os.path.join(settings.ARTIFACTS_DIR, 'k8s_node_name')
    with open(name_path, 'w') as f:
        f.write(str(cluster.get_machine(name=slave_node.name).get_k8s_node_name()))

    # Check/wait for correct docker service replicas in cluster
    ucp_worker_agent_name = cluster.check.get_ucp_worker_agent_name()
    cluster.check.check_actual_expected_docker_services(
        changed_after_upd={'ucp-worker-agent-x': ucp_worker_agent_name})
    cluster.check.check_k8s_pods()
    cluster.check.check_actual_expected_pods(timeout=300)
    cluster.check.check_cluster_readiness()
    cluster.provider_resources.save_artifact()

    if settings.CHILD_MKE_CUSTOM_CERTIFICATES:
        host = cluster.get_load_balancer_address()
        cluster.check.check_cert_conversation(host, port=6443)
        cluster.check.check_cert_equal(port=6443)
