from si_tests.deployments.utils import wait_utils, commons, kubectl_utils, file_utils
from si_tests.deployments.utils.namespace import NAMESPACE


def deploy_iam(os_manager, timeout):
    kubectl = kubectl_utils.Kubectl()
    commons.LOG.info("Deploy IAM components")
    kubectl.apply(file_utils.get_release("3rd-party/50-iam.yaml"))

    wait = wait_utils.Waiter(os_manager, timeout, NAMESPACE.iam)
    commons.LOG.info("Wait for mariadb-server statefulset")
    wait.statefulset("mariadb-server", replicas=3)

    commons.LOG.info("Wait for openstack-iam-keyclo")
    wait.statefulset("openstack-iam-keyclo", replicas=3)

    commons.LOG.info("IAM components successfully deployed")
