#    Copyright 2022 Mirantis, Inc.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations

from si_tests.clients.k8s import base


class V1TFOperator(base.BaseModel):
    pass


class V1TFOperatorList(base.BaseModelList):
    pass


class TFOperator(base.K8sNamespacedResource):
    resource_type = 'tfoperator'
    model = V1TFOperator


class TFOperatorManager(base.K8sBaseManager):
    model = V1TFOperatorList
    resource_class = TFOperator
    resource_group = 'operator.tf.mirantis.com'
    resource_version = 'v1alpha1'
    resource_plural = 'tfoperators'


class V2TFOperator(base.BaseModel):
    pass


class V2TFOperatorList(base.BaseModelList):
    pass


class TFOperatorV2(base.K8sNamespacedResource):
    resource_type = 'tfoperator'
    model = V2TFOperator


class TFOperatorManagerV2(base.K8sBaseManager):
    model = V2TFOperatorList
    resource_class = TFOperatorV2
    resource_group = 'tf.mirantis.com'
    resource_version = 'v2'
    resource_plural = 'tfoperators'
