#    Copyright 2020 Mirantis, Inc.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations

from __future__ import absolute_import

from si_tests.clients.k8s.base import K8sNamespacedResource
from si_tests.clients.k8s.base import K8sBaseManager

from . import models


class KaaSAWSResource(K8sNamespacedResource):
    resource_type = 'awsresource'

    def _read(self, **kwargs):
        response = self._manager.api.get_namespaced_custom_object(
            group=self._manager.resource_group,
            version=self._manager.resource_version,
            namespace=self.namespace,
            name=self.name,
            plural=self._manager.resource_plural,
            **kwargs)
        return self._manager._deserialize_custom_object(
            response, models.V1KaaSAWSResource)

    def _create(self, body, **kwargs):
        response = self._manager.api.create_namespaced_custom_object(
            group=self._manager.resource_group,
            version=self._manager.resource_version,
            namespace=self.namespace,
            plural=self._manager.resource_plural,
            body=body,
            **kwargs)
        return self._manager._deserialize_custom_object(
            response, models.V1KaaSAWSResource)

    def _patch(self, body, **kwargs):
        response = self._manager.api.patch_namespaced_custom_object(
            group=self._manager.resource_group,
            version=self._manager.resource_version,
            namespace=self.namespace,
            plural=self._manager.resource_plural,
            name=self.name,
            body=body,
            **kwargs)
        return self._manager._deserialize_custom_object(
            response, models.V1KaaSAWSResource)

    def _replace(self, body, **kwargs):
        response = self._manager.api.replace_namespaced_custom_object(
            group=self._manager.resource_group,
            version=self._manager.resource_version,
            namespace=self.namespace,
            plural=self._manager.resource_plural,
            name=self.name,
            body=body,
            **kwargs)
        return self._manager._deserialize_custom_object(
            response, models.V1KaaSAWSResource)

    def _delete(self, body=None, **kwargs):
        if not body:
            body = {}
        self._manager.api.delete_namespaced_custom_object(
            group=self._manager.resource_group,
            version=self._manager.resource_version,
            namespace=self.namespace,
            plural=self._manager.resource_plural,
            name=self.name,
            body=body,
            **kwargs)

    @property
    def data(self):
        """Returns dict of k8s object

        Data contains keys like api_version, kind, metadata,
        spec, status or items
        """
        return self.read().to_dict()

    @property
    def regions(self):
        if 'regions' in self.data['status']:
            return self.data['status']['regions'].keys()

    def instance_types(self, region):
        if region in self.data['status']['regions'].keys():
            return self.data['status']['regions'][region]['instanceTypes']

    def images(self, region):
        if region in self.data['status']['regions'].keys():
            return self.data['status']['regions'][region]['AMIs']


class KaaSAWSResourceManager(K8sBaseManager):
    resource_class = KaaSAWSResource
    resource_group = 'kaas.mirantis.com'
    resource_version = 'v1alpha1'
    resource_plural = 'awsresources'

    @property
    def api(self):
        return self._cluster.api_custom

    def _list(self, namespace, **kwargs):
        response = self.api.list_namespaced_custom_object(
            group=self.resource_group,
            version=self.resource_version,
            namespace=namespace,
            plural=self.resource_plural,
            **kwargs)
        return self._deserialize_custom_object_list(
            response,
            models.V1KaaSAWSResourceList,
            models.V1KaaSAWSResource)

    def _list_all(self, **kwargs):
        response = self.api.list_cluster_custom_object(
            group=self.resource_group,
            version=self.resource_version,
            plural=self.resource_plural,
            **kwargs)
        return self._deserialize_custom_object_list(
            response,
            models.V1KaaSAWSResourceList,
            models.V1KaaSAWSResource)
