#    Copyright 2024 Mirantis, Inc.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations

from si_tests.clients.k8s import base

from dateutil import parser
from datetime import datetime
from typing import Dict
import pytz


class V1DiagnosticDiagnostic(base.BaseModel):
    pass


class V1DiagnosticDiagnosticList(base.BaseModelList):
    pass


class DiagnosticDiagnostic(base.K8sNamespacedResource):
    resource_type = "diagnostic"
    model = V1DiagnosticDiagnostic

    @property
    def error(self) -> str:
        return self.data.get('status', {}).get('error', '')

    @property
    def cluster(self) -> str:
        return self.data.get('spec', {}).get('cluster', '')

    @property
    def controller_version(self) -> str:
        return self.data.get('status', {}).get('controllerVersion', '')

    @property
    def result(self) -> Dict[str, dict]:
        return self.data.get('status', {}).get('result', {})

    @property
    def finished_at(self) -> datetime:
        f_at = self.data.get('status', {}).get('finishedAt', '')
        try:
            return parser.parse(f_at).astimezone(pytz.UTC)
        except parser.ParserError:
            return datetime.fromtimestamp(timestamp=0, tz=pytz.UTC)


class DiagnosticDiagnosticManager(base.K8sBaseManager):
    model = V1DiagnosticDiagnosticList
    resource_class = DiagnosticDiagnostic
    resource_group = "diagnostic.mirantis.com"
    resource_version = "v1alpha1"
    resource_plural = "diagnostics"
