import pytest

from si_tests import logger
from si_tests import settings

LOG = logger.logger


@pytest.mark.usefixtures('log_step_time')
@pytest.mark.usefixtures('log_method_time')
def test_install_kof_mothership_manual(kcm_bootstrap_manager, show_step):
    """Install and configure kof into k0rdent management cluster with manual underlay config

    Scenario:
        1. Create kof namespace and generate name prefix
        2. Install kof operators and wait for readiness
        3. Prepare mothership values
        4. Install kof mothership
        5. Install kof regional
        6. Install kof child
    """
    show_step(1)
    kcm_manager = kcm_bootstrap_manager.check.kcm_mgr
    kcm_manager.get_or_create_namespace(settings.KSI_KOF_NAMESPACE)

    show_step(2)
    kcm_manager.kof.install_kof_operators()
    kcm_bootstrap_manager.check.wait_kof_op_ready()
    kcm_manager.refresh_expected_objects()
    kcm_bootstrap_manager.check.check_actual_expected_pods()

    show_step(3)
    values = kcm_manager.kof.get_mothership_values()

    show_step(4)
    kcm_manager.kof.install_kof_mothership(values=values)
    kcm_bootstrap_manager.check.wait_kof_mothership_ready()
    kcm_manager.refresh_expected_objects()
    kcm_bootstrap_manager.check.check_actual_expected_pods()

    show_step(5)
    kcm_manager.kof.install_kof_regional()
    kcm_bootstrap_manager.check.wait_kof_regional_ready()
    kcm_bootstrap_manager.check.check_actual_expected_pods()

    show_step(6)
    kcm_manager.kof.install_kof_child()
    kcm_bootstrap_manager.check.wait_kof_child_ready()
    kcm_bootstrap_manager.check.check_actual_expected_pods()
