from si_tests import logger
from si_tests import settings
from si_tests.managers import ksi_config_manager

LOG = logger.logger


def test_infra_setup_seed(openstack_client, show_step):
    """Install KCM chart into k8s cluster

    Scenario:
        1. Delete(if exists) and create stack
        2. Store information about stack into ksi_config.yaml
    """
    show_step(1)
    # step 001
    if settings.KSI_KEEP_ENV_BEFORE:
        LOG.info("Skip erase due KSI_KEEP_ENV_BEFORE flag is set")
    else:
        if openstack_client._current_stack:
            show_step(1)
            LOG.warning(f"Removing heat stack {settings.ENV_NAME}")
            openstack_client.delete_stack()
        else:
            LOG.warning("Can't erase environment due seed node stack is absent")
    openstack_client.create_seed_node()
    show_step(2)
    seed_ip = openstack_client.get_seed_ip()
    ksi_config = ksi_config_manager.KSIConfigManager(ksi_config_path=settings.KSI_CONFIG_PATH)
    ksi_config.store_seed_ip(seed_ip)
    ksi_config.save_data_to_ksi_config('openstack_env_data', openstack_client._stack_resources_data())
    LOG.info(f'Done, target seedIp:{seed_ip}')
