import requests
from requests import exceptions as rexc

from si_tests import settings
from si_tests import logger
import si_tests.utils.waiters as helpers

LOG = logger.logger


def test_inference_create_delete(box_api_client, inference_manager, show_step):
    """Check create a simple inference workload

    Scenario:
        1. Show available resources from box-api
        2. Get or create a project to test inference workload
        3. Create inference object for nginx:latest
        4. Wait until inference object is ready
        5. Wait until public endpoint is available for the inference
        6. Delete the inference object
    """

    box_cluster_name = settings.KSI_INFERENCE_BOX_CLUSTER_NAME
    project_name = "test-project"
    inference_name = "test-nginx"
    inference_image_name = "nginx:latest"
    inference_flavor_name = "inference-1vcpu-1gib"
    inference_port = 80
    dry_run = None

    show_step(1)
    inference_manager.show_capacity()
    inference_manager.show_gpu_nodes()
    inference_manager.show_flavors()

    show_step(2)
    inference_manager.get_or_create_project(project_name)
    inference_manager.show_projects()

    show_step(3)
    inference_data = {
      "api_keys": [],
      "command": None,
      "description": None,
      "envs": None,
      "envs_per_region": None,
      "expose": None,
      "flavor": {
        "name": inference_flavor_name
      },
      "host_header": None,
      "image": inference_image_name,
      "ingress_opts": {
        "read_timeout": None
      },
      "is_disabled": False,
      "is_ingress_disabled": False,
      "listening_port": inference_port,
      "logging": None,
      "metrics_port": None,
      "name": inference_name,
      "probes": {
        "liveness_probe": {
          "enabled": False,
          "probe": None
        },
        "readiness_probe": {
          "enabled": False,
          "probe": None
        },
        "startup_probe": {
          "enabled": False,
          "probe": None
        }
      },
      "pull_secret": None,
      "regions": [
        box_cluster_name,
        # box_cluster_name2,
      ],
      "registry": None,
      "registry_image": None,
      "registry_user": None,
      "timeout": 180,
      "tls_secret": None,
      "volumes": [],
      "scale_per_region": {
        box_cluster_name: {
          "min": 1,
          "max": 1,
          "cooldown_period": 60,
          "triggers": {
            "cpu": {
              "threshold": 80
            },
            "gpu_memory": None,
            "gpu_utilization": {
              "threshold": 80
            },
            "http": None,
            "memory": None
          }
        },
        # box_cluster_name2 : {...}
      },
    }
    inference_manager.create_inference(project_name, inference_data, dry_run)

    show_step(4)
    inference_manager.wait_inference_ready(project_name=project_name, inference_name=inference_name)

    show_step(5)
    addresses = inference_manager.get_inference_addresses(project_name=project_name, inference_name=inference_name)
    for region, address in addresses.items():
        LOG.info(f"Wait until address '{address}' become available in region '{region}' ...")
        helpers.wait_pass(lambda: requests.get(address, verify=False),
                          timeout=1800,
                          interval=15,
                          expected=(Exception, rexc.Timeout, rexc.ConnectTimeout,
                                    rexc.ReadTimeout, rexc.ConnectionError))
        resp = requests.get(address, verify=False)
        assert "Welcome to nginx!" in resp.text, (
            f"Unexpected response from region '{region}' on address '{address}'. "
            f"Expected 'Welcome to nginx!', got:\n{resp.text}")
        LOG.info(f"Response from region '{region}':\n{resp.text}")

    show_step(6)
    addresses = inference_manager.delete_inference(project_name=project_name, inference_name=inference_name)
