#    Copyright 2025 Mirantis, Inc.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations

from si_tests.clients.k8s import base


class V1AzureClusterIdentity(base.BaseModel):
    pass


class V1AzureClusterIdentityList(base.BaseModelList):
    pass


class AzureClusterIdentity(base.K8sNamespacedResource):
    resource_type = 'azureclusteridentity'
    model = V1AzureClusterIdentity


class AzureClusterIdentityManager(base.K8sBaseManager):
    model = V1AzureClusterIdentityList
    resource_class = AzureClusterIdentity
    resource_group = 'infrastructure.cluster.x-k8s.io'
    resource_version = 'v1beta1'
    resource_plural = 'azureclusteridentities'
