#    Copyright 2025 Mirantis, Inc.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations

from si_tests.clients.k8s import base


class V1AzureASOManagedCluster(base.BaseModel):
    pass


class V1AzureASOManagedClusterList(base.BaseModelList):
    pass


class AzureASOManagedCluster(base.K8sNamespacedResource):
    resource_type = 'azureasomanagedcluster'
    model = V1AzureASOManagedCluster

    def __init__(self, manager, name=None, namespace=None, data=None, log=True):
        """
        AzureASOManagedCluster object functions
        Represents Azure AKS deployments for k0rdent templates
        """
        self._systempool = None
        self._userpool = None
        super().__init__(manager, name, namespace, data, log)

    @property
    def ready(self):
        return self.read().status['ready']

    @property
    def systempool(self):
        if not self._systempool:
            # NOTE(va4st): this is k0rdent-specific naming that hardcoded
            name_pattern = f"{self.name}-system"
            self._systempool = self._manager._cluster.azureasomanagedmachinepools.get(
                name=name_pattern, namespace=self.namespace)
        return self._systempool

    @property
    def userpool(self):
        if not self._userpool:
            name_pattern = f"{self.name}-user"
            self._userpool = self._manager._cluster.azureasomanagedmachinepools.get(
                name=name_pattern, namespace=self.namespace)
        return self._userpool


class AzureASOManagedClusterManager(base.K8sBaseManager):
    model = V1AzureASOManagedClusterList
    resource_class = AzureASOManagedCluster
    resource_group = 'infrastructure.cluster.x-k8s.io'
    resource_version = 'v1alpha1'
    resource_plural = 'azureasomanagedclusters'
