# coding: utf-8

"""
    Inference Box API

    ## Welcome to Inference Box API  A comprehensive REST API for managing cloud infrastructure resources including ML inference deployments, Kubernetes resources, and application lifecycle management.  ## Overview  Inference Box API is a cloud-native REST API service that provides unified access to manage:  - **ML Inference Deployments**: Create, manage, and scale machine learning inference services - **Slurm Clusters**: Deploy, configure, and manage HPC Slurm clusters for batch workloads - **Kubernetes Resources**: Manage namespaces (projects), pods, secrets, volumes, and other K8s resources - **Application Lifecycle**: Deploy and manage applications from catalog templates - **Resource Management**: Handle flavors, capacities, quotas, and node groups - **User & Access Control**: Manage users, groups, and API keys with RBAC integration - **Monitoring & Metrics**: Query metrics and monitor resource usage via Victoria Metrics  The service is built with Go and integrates with Kubernetes, HashiCorp Vault, and Victoria Metrics to provide a complete cloud infrastructure management solution.  ## Key API Endpoints  - **Inference**: `/v1/{project_name}/inferences` - ML inference deployment management - **Slurm Clusters**: `/v1/{project_name}/slurm/clusters` - Slurm cluster deployment and management - **Flavors**: `/v1/flavors` - Compute resource flavor definitions - **Users**: `/v1/admin/users` - User management (admin only) - **Projects**: `/v1/{project_name}` - Project-scoped resource operations - **Metrics**: `/v1/{project_name}/metrics` - Resource usage metrics  ## Getting Started  ### Authentication  All API requests require authentication using the `X-API-Key` header. Most operations are scoped to specific projects/namespaces.  ### API Organization  The API is organized into logical groups: - **Public endpoints**: `/v1/*` - General access endpoints - **Project-scoped**: `/v1/{project_name}/*` - Project-specific resources - **Admin endpoints**: `/v1/admin/*` - Administrative operations  ### Documentation  Interactive documentation is available at `/docs` when the service is running. 

    The version of the OpenAPI document: 2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from si_tests.clients.gcore.box_api.models.v1_exec_probe import V1ExecProbe
from si_tests.clients.gcore.box_api.models.v1_http_get_probe import V1HttpGetProbe
from si_tests.clients.gcore.box_api.models.v1_tcp_socket_probe import V1TcpSocketProbe
from typing import Optional, Set
from typing_extensions import Self

class V1ContainerProbe(BaseModel):
    """
    V1ContainerProbe
    """ # noqa: E501
    var_exec: Optional[V1ExecProbe] = Field(default=None, alias="exec")
    failure_threshold: Optional[StrictInt] = Field(default=None, description="FailureThreshold After a probe fails failureThreshold times in a row, Kubernetes considers that the overall check has failed: the container is not ready/healthy/live.")
    http_get: Optional[V1HttpGetProbe] = None
    initial_delay_seconds: Optional[StrictInt] = Field(default=None, description="InitialDelaySeconds Number of seconds after the container has started before startup, liveness or readiness probes are initiated.")
    period_seconds: Optional[StrictInt] = Field(default=None, description="PeriodSeconds How often (in seconds) to perform the probe.")
    success_threshold: Optional[StrictInt] = Field(default=None, description="SuccessThreshold Minimum consecutive successes for the probe to be considered successful after having failed.")
    tcp_socket: Optional[V1TcpSocketProbe] = None
    timeout_seconds: Optional[StrictInt] = Field(default=None, description="TimeoutSeconds Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1.")
    __properties: ClassVar[List[str]] = ["exec", "failure_threshold", "http_get", "initial_delay_seconds", "period_seconds", "success_threshold", "tcp_socket", "timeout_seconds"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V1ContainerProbe from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of var_exec
        if self.var_exec:
            _dict['exec'] = self.var_exec.to_dict()
        # override the default output from pydantic by calling `to_dict()` of http_get
        if self.http_get:
            _dict['http_get'] = self.http_get.to_dict()
        # override the default output from pydantic by calling `to_dict()` of tcp_socket
        if self.tcp_socket:
            _dict['tcp_socket'] = self.tcp_socket.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V1ContainerProbe from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "exec": V1ExecProbe.from_dict(obj["exec"]) if obj.get("exec") is not None else None,
            "failure_threshold": obj.get("failure_threshold"),
            "http_get": V1HttpGetProbe.from_dict(obj["http_get"]) if obj.get("http_get") is not None else None,
            "initial_delay_seconds": obj.get("initial_delay_seconds"),
            "period_seconds": obj.get("period_seconds"),
            "success_threshold": obj.get("success_threshold"),
            "tcp_socket": V1TcpSocketProbe.from_dict(obj["tcp_socket"]) if obj.get("tcp_socket") is not None else None,
            "timeout_seconds": obj.get("timeout_seconds")
        })
        return _obj


