# V1VolumeResponse


## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**empty_dir** | [**V1EmptyDirVolumeSource**](V1EmptyDirVolumeSource.md) |  | [optional] 
**image** | [**V1ImageVolumeSource**](V1ImageVolumeSource.md) |  | [optional] 
**managed** | **bool** | Managed indicates whether the volume is managed by another object. A managed volume cannot be modified or deleted directly. | [optional] 
**name** | **str** | Name is the volume name | [optional] 
**object_references** | [**List[ApiUtilReferencesObjectReference]**](ApiUtilReferencesObjectReference.md) | ObjectReferences lists parent objects referencing this volume. | [optional] 
**pvc** | [**V1PVCVolumeSource**](V1PVCVolumeSource.md) |  | [optional] 
**regions** | **List[str]** | Regions is the list of regions where the volume should be available. | [optional] 
**status** | **str** | Status is the combined volume status across regions, e.g. \&quot;Active\&quot; or \&quot;Pending\&quot;. | [optional] 
**statuses** | [**Dict[str, V1RegionalVolumeStatus]**](V1RegionalVolumeStatus.md) | Statuses is a map of regional volume statuses keyed by region name. | [optional] 

## Example

```python
from si_tests.clients.gcore.box_api.models.v1_volume_response import V1VolumeResponse

# TODO update the JSON string below
json = "{}"
# create an instance of V1VolumeResponse from a JSON string
v1_volume_response_instance = V1VolumeResponse.from_json(json)
# print the JSON string representation of the object
print(V1VolumeResponse.to_json())

# convert the object into a dict
v1_volume_response_dict = v1_volume_response_instance.to_dict()
# create an instance of V1VolumeResponse from a dict
v1_volume_response_from_dict = V1VolumeResponse.from_dict(v1_volume_response_dict)
```
[[Back to Model list]](../README.md#documentation-for-models) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to README]](../README.md)


