# si_tests.clients.gcore.box_api.CapacityApi

All URIs are relative to *http://localhost*

Method | HTTP request | Description
------------- | ------------- | -------------
[**v1_list_capacities**](CapacityApi.md#v1_list_capacities) | **GET** /v1/capacities | List available capacities
[**v1_list_capacities_per_namesapce**](CapacityApi.md#v1_list_capacities_per_namesapce) | **GET** /v1/capacities/{project_name} | List project available capacities


# **v1_list_capacities**
> Dict[str, Dict[str, int]] v1_list_capacities()

List available capacities

Returns available capacities for each flavor in each region. The response is a map where keys are region names and values are maps of flavor names to their available capacity count.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.CapacityApi(api_client)

    try:
        # List available capacities
        api_response = api_instance.v1_list_capacities()
        print("The response of CapacityApi->v1_list_capacities:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling CapacityApi->v1_list_capacities: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

**Dict[str, Dict[str, int]]**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_list_capacities_per_namesapce**
> Dict[str, Dict[str, int]] v1_list_capacities_per_namesapce(project_name)

List project available capacities

Returns available capacities for each flavor in each region for the specified project. The response is a map where keys are region names and values are maps of flavor names to their available capacity count.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.CapacityApi(api_client)
    project_name = 'project_name_example' # str | Project name

    try:
        # List project available capacities
        api_response = api_instance.v1_list_capacities_per_namesapce(project_name)
        print("The response of CapacityApi->v1_list_capacities_per_namesapce:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling CapacityApi->v1_list_capacities_per_namesapce: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **project_name** | **str**| Project name | 

### Return type

**Dict[str, Dict[str, int]]**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

