# coding: utf-8

# flake8: noqa

"""
    Inference Box API

    ## Welcome to Inference Box API  A comprehensive REST API for managing cloud infrastructure resources including ML inference deployments, Kubernetes resources, and application lifecycle management.  ## Overview  Inference Box API is a cloud-native REST API service that provides unified access to manage:  - **ML Inference Deployments**: Create, manage, and scale machine learning inference services - **Slurm Clusters**: Deploy, configure, and manage HPC Slurm clusters for batch workloads - **Kubernetes Resources**: Manage namespaces (projects), pods, secrets, volumes, and other K8s resources - **Application Lifecycle**: Deploy and manage applications from catalog templates - **Resource Management**: Handle flavors, capacities, quotas, and node groups - **User & Access Control**: Manage users, groups, and API keys with RBAC integration - **Monitoring & Metrics**: Query metrics and monitor resource usage via Victoria Metrics  The service is built with Go and integrates with Kubernetes, HashiCorp Vault, and Victoria Metrics to provide a complete cloud infrastructure management solution.  ## Key API Endpoints  - **Inference**: `/v1/{project_name}/inferences` - ML inference deployment management - **Slurm Clusters**: `/v1/{project_name}/slurm/clusters` - Slurm cluster deployment and management - **Flavors**: `/v1/flavors` - Compute resource flavor definitions - **Users**: `/v1/admin/users` - User management (admin only) - **Projects**: `/v1/{project_name}` - Project-scoped resource operations - **Metrics**: `/v1/{project_name}/metrics` - Resource usage metrics  ## Getting Started  ### Authentication  All API requests require authentication using the `X-API-Key` header. Most operations are scoped to specific projects/namespaces.  ### API Organization  The API is organized into logical groups: - **Public endpoints**: `/v1/*` - General access endpoints - **Project-scoped**: `/v1/{project_name}/*` - Project-specific resources - **Admin endpoints**: `/v1/admin/*` - Administrative operations  ### Documentation  Interactive documentation is available at `/docs` when the service is running. 

    The version of the OpenAPI document: 2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


__version__ = "1.0.0"

# Define package exports
__all__ = [
    "APIKeysApi",
    "AppsApi",
    "AuditLogsApi",
    "AutodiscoveryApi",
    "CapacityApi",
    "DashboardApi",
    "FlavorsApi",
    "InferencesApi",
    "JupyterLabApi",
    "MetricsApi",
    "NamespacesApi",
    "NodeGroupsApi",
    "NodesApi",
    "PodsApi",
    "ProjectsApi",
    "PullSecretsApi",
    "QuotasApi",
    "RegionsApi",
    "RegistriesApi",
    "RegistryUsersApi",
    "SecretsApi",
    "SlurmApi",
    "TLSSecretsApi",
    "UserGroupsApi",
    "UsersApi",
    "VolumesApi",
    "ApiResponse",
    "ApiClient",
    "Configuration",
    "OpenApiException",
    "ApiTypeError",
    "ApiValueError",
    "ApiKeyError",
    "ApiAttributeError",
    "ApiException",
    "ApiErrorResponse",
    "ApiServicesAutodiscoveriesV1ListNodesResponse",
    "ApiServicesAutodiscoveriesV1NodeResponse",
    "ApiServicesInferenceV1Flavor",
    "ApiServicesInferenceV1Volume",
    "ApiServicesNodegroupsV1ListNodesResponse",
    "ApiServicesNodegroupsV1NodeResponse",
    "ApiServicesOverviewV1PreheatPolicy",
    "ApiServicesOverviewV1PreheatPolicyFilters",
    "ApiServicesOverviewV1PreheatPolicyTrigger",
    "ApiServicesOverviewV1Region",
    "ApiServicesOverviewV1RegistryResponse",
    "ApiServicesRegistriesV1PreheatPolicy",
    "ApiServicesRegistriesV1PreheatPolicyFilters",
    "ApiServicesRegistriesV1PreheatPolicyTrigger",
    "ApiServicesRegistriesV1RegistryResponse",
    "ApiServicesSecretsV1SecretResponse",
    "ApiServicesUsersV1SecretResponse",
    "ApiUtilReferencesObjectReference",
    "ApiValidationErrorResponse",
    "AutodiscoveryRegionType",
    "SchemasApp",
    "SchemasAppComponent",
    "SchemasAppDeployment",
    "SchemasAppDeploymentCreateRequest",
    "SchemasAppDeploymentList",
    "SchemasAppDeploymentPatchRequest",
    "SchemasAppInference",
    "SchemasAppListResponse",
    "SchemasComponentConfiguration",
    "SchemasComponentConfigurationPatch",
    "SchemasComponentStatus",
    "SchemasExposeAddress",
    "SchemasParameter",
    "SchemasParameterOverride",
    "SchemasParameterType",
    "SchemasRegionStatus",
    "SchemasScale",
    "SchemasScalePatch",
    "SchemasShortFlavor",
    "SchemasStatus",
    "V1AccessRule",
    "V1ActionRequests",
    "V1ApiKeyResponse",
    "V1AuditLogResponse",
    "V1AuditLogsResponse",
    "V1Cluster",
    "V1ContainerProbe",
    "V1CpuTrigger",
    "V1CreateApiKeyRequest",
    "V1CreateFlavorRequest",
    "V1CreateGroupRequest",
    "V1CreateInferenceRequest",
    "V1CreateInstanceRequest",
    "V1CreateInstanceResponse",
    "V1CreateNamespaceRequest",
    "V1CreateNodeGroupRequest",
    "V1CreateProjectRequest",
    "V1CreatePullSecretRequest",
    "V1CreateQuotaRequest",
    "V1CreateRegistryRequest",
    "V1CreateRegistryUserRequest",
    "V1CreateScaleRequest",
    "V1CreateScaleTriggers",
    "V1CreateSecretRequest",
    "V1CreateSlurmClusterLoginConfig",
    "V1CreateSlurmClusterRequest",
    "V1CreateSlurmClusterWorkerConfig",
    "V1CreateSubRegionRequest",
    "V1CreateTlsSecretRequest",
    "V1CreateUserRequest",
    "V1CreateVolumeRequest",
    "V1DeploymentStatus",
    "V1DeschedulePodRequest",
    "V1EmptyDirVolumeSource",
    "V1ExecProbe",
    "V1FlavorRef",
    "V1FlavorResponse",
    "V1GetApiKeyResponse",
    "V1GetInstanceResponse",
    "V1GetMetricsForPodResponse",
    "V1GetPodsMetricsResponse",
    "V1GpuMemoryTrigger",
    "V1GpuUtilizationTrigger",
    "V1GroupResponse",
    "V1HttpGetProbe",
    "V1HttpTrigger",
    "V1ImageResponse",
    "V1ImageVolumeSource",
    "V1InferenceAPIKeySecretResponse",
    "V1InferenceLog",
    "V1InferenceLogsResponse",
    "V1InferenceResponse",
    "V1IngressOpts",
    "V1ListApiKeysResponse",
    "V1ListFlavorResponse",
    "V1ListGroupResponse",
    "V1ListImagesResponse",
    "V1ListInferenceResponse",
    "V1ListInstanceResponse",
    "V1ListNamespaceResponse",
    "V1ListNodeGroupResponse",
    "V1ListProjectResponse",
    "V1ListPullSecretResponse",
    "V1ListQuotasResponse",
    "V1ListRegionResponse",
    "V1ListRegistryResponse",
    "V1ListRegistryUserResponse",
    "V1ListSecretResponse",
    "V1ListSlurmClustersResponse",
    "V1ListStorageClassesResponse",
    "V1ListSubRegionResponse",
    "V1ListTlsSecretResponse",
    "V1ListUserResponse",
    "V1ListVolumesResponse",
    "V1Logging",
    "V1LoginResponse",
    "V1LoginUserRequest",
    "V1MemoryTrigger",
    "V1MetricsQueryData",
    "V1MetricsQueryResponse",
    "V1NamespaceResponse",
    "V1Node",
    "V1NodeGroupResponse",
    "V1NodeListResponse",
    "V1NodesPerRegion",
    "V1OverviewResponse",
    "V1PVCVolumeSource",
    "V1PatchApiKeyRequest",
    "V1PatchSlurmClusterRequest",
    "V1PatchSlurmClusterWorkerConfig",
    "V1Pod",
    "V1ProbeConfiguration",
    "V1Probes",
    "V1ProjectResponse",
    "V1PullSecretResponse",
    "V1QuotaResponse",
    "V1RefreshRequest",
    "V1RegionResponse",
    "V1RegionalVolumeStatus",
    "V1RegistryImageRef",
    "V1RegistryRef",
    "V1RegistryUserRef",
    "V1RegistryUserResponse",
    "V1ResourceTypesResponse",
    "V1Scale",
    "V1SlurmClusterLoginConfig",
    "V1SlurmClusterResponse",
    "V1SlurmClusterWorkerConfig",
    "V1SqsTrigger",
    "V1Status",
    "V1StorageClassResponse",
    "V1SubRegionResponse",
    "V1TcpSocketProbe",
    "V1TlsSecretResponse",
    "V1TriggersResponse",
    "V1UpdateApiKeyRequest",
    "V1UpdateGroupRequest",
    "V1UpdateInferenceRequest",
    "V1UpdateInstanceRequest",
    "V1UpdateInstanceResponse",
    "V1UpdateNodeGroupRequest",
    "V1UpdatePullSecretRequest",
    "V1UpdateQuotaRequest",
    "V1UpdateRegistryRequest",
    "V1UpdateRegistryUserRequest",
    "V1UpdateSecretRequest",
    "V1UpdateSubRegionRequest",
    "V1UpdateTlsSecretRequest",
    "V1UpdateUserRequest",
    "V1UpdateUserSecretRequest",
    "V1UpdateVolumeRequest",
    "V1UserResponse",
    "V1VolumeResponse",
]

# import apis into sdk package
from si_tests.clients.gcore.box_api.api.api_keys_api import APIKeysApi as APIKeysApi
from si_tests.clients.gcore.box_api.api.apps_api import AppsApi as AppsApi
from si_tests.clients.gcore.box_api.api.audit_logs_api import AuditLogsApi as AuditLogsApi
from si_tests.clients.gcore.box_api.api.autodiscovery_api import AutodiscoveryApi as AutodiscoveryApi
from si_tests.clients.gcore.box_api.api.capacity_api import CapacityApi as CapacityApi
from si_tests.clients.gcore.box_api.api.dashboard_api import DashboardApi as DashboardApi
from si_tests.clients.gcore.box_api.api.flavors_api import FlavorsApi as FlavorsApi
from si_tests.clients.gcore.box_api.api.inferences_api import InferencesApi as InferencesApi
from si_tests.clients.gcore.box_api.api.jupyter_lab_api import JupyterLabApi as JupyterLabApi
from si_tests.clients.gcore.box_api.api.metrics_api import MetricsApi as MetricsApi
from si_tests.clients.gcore.box_api.api.namespaces_api import NamespacesApi as NamespacesApi
from si_tests.clients.gcore.box_api.api.node_groups_api import NodeGroupsApi as NodeGroupsApi
from si_tests.clients.gcore.box_api.api.nodes_api import NodesApi as NodesApi
from si_tests.clients.gcore.box_api.api.pods_api import PodsApi as PodsApi
from si_tests.clients.gcore.box_api.api.projects_api import ProjectsApi as ProjectsApi
from si_tests.clients.gcore.box_api.api.pull_secrets_api import PullSecretsApi as PullSecretsApi
from si_tests.clients.gcore.box_api.api.quotas_api import QuotasApi as QuotasApi
from si_tests.clients.gcore.box_api.api.regions_api import RegionsApi as RegionsApi
from si_tests.clients.gcore.box_api.api.registries_api import RegistriesApi as RegistriesApi
from si_tests.clients.gcore.box_api.api.registry_users_api import RegistryUsersApi as RegistryUsersApi
from si_tests.clients.gcore.box_api.api.secrets_api import SecretsApi as SecretsApi
from si_tests.clients.gcore.box_api.api.slurm_api import SlurmApi as SlurmApi
from si_tests.clients.gcore.box_api.api.tls_secrets_api import TLSSecretsApi as TLSSecretsApi
from si_tests.clients.gcore.box_api.api.user_groups_api import UserGroupsApi as UserGroupsApi
from si_tests.clients.gcore.box_api.api.users_api import UsersApi as UsersApi
from si_tests.clients.gcore.box_api.api.volumes_api import VolumesApi as VolumesApi

# import ApiClient
from si_tests.clients.gcore.box_api.api_response import ApiResponse as ApiResponse
from si_tests.clients.gcore.box_api.api_client import ApiClient as ApiClient
from si_tests.clients.gcore.box_api.configuration import Configuration as Configuration
from si_tests.clients.gcore.box_api.exceptions import OpenApiException as OpenApiException
from si_tests.clients.gcore.box_api.exceptions import ApiTypeError as ApiTypeError
from si_tests.clients.gcore.box_api.exceptions import ApiValueError as ApiValueError
from si_tests.clients.gcore.box_api.exceptions import ApiKeyError as ApiKeyError
from si_tests.clients.gcore.box_api.exceptions import ApiAttributeError as ApiAttributeError
from si_tests.clients.gcore.box_api.exceptions import ApiException as ApiException

# import models into sdk package
from si_tests.clients.gcore.box_api.models.api_error_response import ApiErrorResponse as ApiErrorResponse
from si_tests.clients.gcore.box_api.models.api_services_autodiscoveries_v1_list_nodes_response import ApiServicesAutodiscoveriesV1ListNodesResponse as ApiServicesAutodiscoveriesV1ListNodesResponse
from si_tests.clients.gcore.box_api.models.api_services_autodiscoveries_v1_node_response import ApiServicesAutodiscoveriesV1NodeResponse as ApiServicesAutodiscoveriesV1NodeResponse
from si_tests.clients.gcore.box_api.models.api_services_inference_v1_flavor import ApiServicesInferenceV1Flavor as ApiServicesInferenceV1Flavor
from si_tests.clients.gcore.box_api.models.api_services_inference_v1_volume import ApiServicesInferenceV1Volume as ApiServicesInferenceV1Volume
from si_tests.clients.gcore.box_api.models.api_services_nodegroups_v1_list_nodes_response import ApiServicesNodegroupsV1ListNodesResponse as ApiServicesNodegroupsV1ListNodesResponse
from si_tests.clients.gcore.box_api.models.api_services_nodegroups_v1_node_response import ApiServicesNodegroupsV1NodeResponse as ApiServicesNodegroupsV1NodeResponse
from si_tests.clients.gcore.box_api.models.api_services_overview_v1_preheat_policy import ApiServicesOverviewV1PreheatPolicy as ApiServicesOverviewV1PreheatPolicy
from si_tests.clients.gcore.box_api.models.api_services_overview_v1_preheat_policy_filters import ApiServicesOverviewV1PreheatPolicyFilters as ApiServicesOverviewV1PreheatPolicyFilters
from si_tests.clients.gcore.box_api.models.api_services_overview_v1_preheat_policy_trigger import ApiServicesOverviewV1PreheatPolicyTrigger as ApiServicesOverviewV1PreheatPolicyTrigger
from si_tests.clients.gcore.box_api.models.api_services_overview_v1_region import ApiServicesOverviewV1Region as ApiServicesOverviewV1Region
from si_tests.clients.gcore.box_api.models.api_services_overview_v1_registry_response import ApiServicesOverviewV1RegistryResponse as ApiServicesOverviewV1RegistryResponse
from si_tests.clients.gcore.box_api.models.api_services_registries_v1_preheat_policy import ApiServicesRegistriesV1PreheatPolicy as ApiServicesRegistriesV1PreheatPolicy
from si_tests.clients.gcore.box_api.models.api_services_registries_v1_preheat_policy_filters import ApiServicesRegistriesV1PreheatPolicyFilters as ApiServicesRegistriesV1PreheatPolicyFilters
from si_tests.clients.gcore.box_api.models.api_services_registries_v1_preheat_policy_trigger import ApiServicesRegistriesV1PreheatPolicyTrigger as ApiServicesRegistriesV1PreheatPolicyTrigger
from si_tests.clients.gcore.box_api.models.api_services_registries_v1_registry_response import ApiServicesRegistriesV1RegistryResponse as ApiServicesRegistriesV1RegistryResponse
from si_tests.clients.gcore.box_api.models.api_services_secrets_v1_secret_response import ApiServicesSecretsV1SecretResponse as ApiServicesSecretsV1SecretResponse
from si_tests.clients.gcore.box_api.models.api_services_users_v1_secret_response import ApiServicesUsersV1SecretResponse as ApiServicesUsersV1SecretResponse
from si_tests.clients.gcore.box_api.models.api_util_references_object_reference import ApiUtilReferencesObjectReference as ApiUtilReferencesObjectReference
from si_tests.clients.gcore.box_api.models.api_validation_error_response import ApiValidationErrorResponse as ApiValidationErrorResponse
from si_tests.clients.gcore.box_api.models.autodiscovery_region_type import AutodiscoveryRegionType as AutodiscoveryRegionType
from si_tests.clients.gcore.box_api.models.schemas_app import SchemasApp as SchemasApp
from si_tests.clients.gcore.box_api.models.schemas_app_component import SchemasAppComponent as SchemasAppComponent
from si_tests.clients.gcore.box_api.models.schemas_app_deployment import SchemasAppDeployment as SchemasAppDeployment
from si_tests.clients.gcore.box_api.models.schemas_app_deployment_create_request import SchemasAppDeploymentCreateRequest as SchemasAppDeploymentCreateRequest
from si_tests.clients.gcore.box_api.models.schemas_app_deployment_list import SchemasAppDeploymentList as SchemasAppDeploymentList
from si_tests.clients.gcore.box_api.models.schemas_app_deployment_patch_request import SchemasAppDeploymentPatchRequest as SchemasAppDeploymentPatchRequest
from si_tests.clients.gcore.box_api.models.schemas_app_inference import SchemasAppInference as SchemasAppInference
from si_tests.clients.gcore.box_api.models.schemas_app_list_response import SchemasAppListResponse as SchemasAppListResponse
from si_tests.clients.gcore.box_api.models.schemas_component_configuration import SchemasComponentConfiguration as SchemasComponentConfiguration
from si_tests.clients.gcore.box_api.models.schemas_component_configuration_patch import SchemasComponentConfigurationPatch as SchemasComponentConfigurationPatch
from si_tests.clients.gcore.box_api.models.schemas_component_status import SchemasComponentStatus as SchemasComponentStatus
from si_tests.clients.gcore.box_api.models.schemas_expose_address import SchemasExposeAddress as SchemasExposeAddress
from si_tests.clients.gcore.box_api.models.schemas_parameter import SchemasParameter as SchemasParameter
from si_tests.clients.gcore.box_api.models.schemas_parameter_override import SchemasParameterOverride as SchemasParameterOverride
from si_tests.clients.gcore.box_api.models.schemas_parameter_type import SchemasParameterType as SchemasParameterType
from si_tests.clients.gcore.box_api.models.schemas_region_status import SchemasRegionStatus as SchemasRegionStatus
from si_tests.clients.gcore.box_api.models.schemas_scale import SchemasScale as SchemasScale
from si_tests.clients.gcore.box_api.models.schemas_scale_patch import SchemasScalePatch as SchemasScalePatch
from si_tests.clients.gcore.box_api.models.schemas_short_flavor import SchemasShortFlavor as SchemasShortFlavor
from si_tests.clients.gcore.box_api.models.schemas_status import SchemasStatus as SchemasStatus
from si_tests.clients.gcore.box_api.models.v1_access_rule import V1AccessRule as V1AccessRule
from si_tests.clients.gcore.box_api.models.v1_action_requests import V1ActionRequests as V1ActionRequests
from si_tests.clients.gcore.box_api.models.v1_api_key_response import V1ApiKeyResponse as V1ApiKeyResponse
from si_tests.clients.gcore.box_api.models.v1_audit_log_response import V1AuditLogResponse as V1AuditLogResponse
from si_tests.clients.gcore.box_api.models.v1_audit_logs_response import V1AuditLogsResponse as V1AuditLogsResponse
from si_tests.clients.gcore.box_api.models.v1_cluster import V1Cluster as V1Cluster
from si_tests.clients.gcore.box_api.models.v1_container_probe import V1ContainerProbe as V1ContainerProbe
from si_tests.clients.gcore.box_api.models.v1_cpu_trigger import V1CpuTrigger as V1CpuTrigger
from si_tests.clients.gcore.box_api.models.v1_create_api_key_request import V1CreateApiKeyRequest as V1CreateApiKeyRequest
from si_tests.clients.gcore.box_api.models.v1_create_flavor_request import V1CreateFlavorRequest as V1CreateFlavorRequest
from si_tests.clients.gcore.box_api.models.v1_create_group_request import V1CreateGroupRequest as V1CreateGroupRequest
from si_tests.clients.gcore.box_api.models.v1_create_inference_request import V1CreateInferenceRequest as V1CreateInferenceRequest
from si_tests.clients.gcore.box_api.models.v1_create_instance_request import V1CreateInstanceRequest as V1CreateInstanceRequest
from si_tests.clients.gcore.box_api.models.v1_create_instance_response import V1CreateInstanceResponse as V1CreateInstanceResponse
from si_tests.clients.gcore.box_api.models.v1_create_namespace_request import V1CreateNamespaceRequest as V1CreateNamespaceRequest
from si_tests.clients.gcore.box_api.models.v1_create_node_group_request import V1CreateNodeGroupRequest as V1CreateNodeGroupRequest
from si_tests.clients.gcore.box_api.models.v1_create_project_request import V1CreateProjectRequest as V1CreateProjectRequest
from si_tests.clients.gcore.box_api.models.v1_create_pull_secret_request import V1CreatePullSecretRequest as V1CreatePullSecretRequest
from si_tests.clients.gcore.box_api.models.v1_create_quota_request import V1CreateQuotaRequest as V1CreateQuotaRequest
from si_tests.clients.gcore.box_api.models.v1_create_registry_request import V1CreateRegistryRequest as V1CreateRegistryRequest
from si_tests.clients.gcore.box_api.models.v1_create_registry_user_request import V1CreateRegistryUserRequest as V1CreateRegistryUserRequest
from si_tests.clients.gcore.box_api.models.v1_create_scale_request import V1CreateScaleRequest as V1CreateScaleRequest
from si_tests.clients.gcore.box_api.models.v1_create_scale_triggers import V1CreateScaleTriggers as V1CreateScaleTriggers
from si_tests.clients.gcore.box_api.models.v1_create_secret_request import V1CreateSecretRequest as V1CreateSecretRequest
from si_tests.clients.gcore.box_api.models.v1_create_slurm_cluster_login_config import V1CreateSlurmClusterLoginConfig as V1CreateSlurmClusterLoginConfig
from si_tests.clients.gcore.box_api.models.v1_create_slurm_cluster_request import V1CreateSlurmClusterRequest as V1CreateSlurmClusterRequest
from si_tests.clients.gcore.box_api.models.v1_create_slurm_cluster_worker_config import V1CreateSlurmClusterWorkerConfig as V1CreateSlurmClusterWorkerConfig
from si_tests.clients.gcore.box_api.models.v1_create_sub_region_request import V1CreateSubRegionRequest as V1CreateSubRegionRequest
from si_tests.clients.gcore.box_api.models.v1_create_tls_secret_request import V1CreateTlsSecretRequest as V1CreateTlsSecretRequest
from si_tests.clients.gcore.box_api.models.v1_create_user_request import V1CreateUserRequest as V1CreateUserRequest
from si_tests.clients.gcore.box_api.models.v1_create_volume_request import V1CreateVolumeRequest as V1CreateVolumeRequest
from si_tests.clients.gcore.box_api.models.v1_deployment_status import V1DeploymentStatus as V1DeploymentStatus
from si_tests.clients.gcore.box_api.models.v1_deschedule_pod_request import V1DeschedulePodRequest as V1DeschedulePodRequest
from si_tests.clients.gcore.box_api.models.v1_empty_dir_volume_source import V1EmptyDirVolumeSource as V1EmptyDirVolumeSource
from si_tests.clients.gcore.box_api.models.v1_exec_probe import V1ExecProbe as V1ExecProbe
from si_tests.clients.gcore.box_api.models.v1_flavor_ref import V1FlavorRef as V1FlavorRef
from si_tests.clients.gcore.box_api.models.v1_flavor_response import V1FlavorResponse as V1FlavorResponse
from si_tests.clients.gcore.box_api.models.v1_get_api_key_response import V1GetApiKeyResponse as V1GetApiKeyResponse
from si_tests.clients.gcore.box_api.models.v1_get_instance_response import V1GetInstanceResponse as V1GetInstanceResponse
from si_tests.clients.gcore.box_api.models.v1_get_metrics_for_pod_response import V1GetMetricsForPodResponse as V1GetMetricsForPodResponse
from si_tests.clients.gcore.box_api.models.v1_get_pods_metrics_response import V1GetPodsMetricsResponse as V1GetPodsMetricsResponse
from si_tests.clients.gcore.box_api.models.v1_gpu_memory_trigger import V1GpuMemoryTrigger as V1GpuMemoryTrigger
from si_tests.clients.gcore.box_api.models.v1_gpu_utilization_trigger import V1GpuUtilizationTrigger as V1GpuUtilizationTrigger
from si_tests.clients.gcore.box_api.models.v1_group_response import V1GroupResponse as V1GroupResponse
from si_tests.clients.gcore.box_api.models.v1_http_get_probe import V1HttpGetProbe as V1HttpGetProbe
from si_tests.clients.gcore.box_api.models.v1_http_trigger import V1HttpTrigger as V1HttpTrigger
from si_tests.clients.gcore.box_api.models.v1_image_response import V1ImageResponse as V1ImageResponse
from si_tests.clients.gcore.box_api.models.v1_image_volume_source import V1ImageVolumeSource as V1ImageVolumeSource
from si_tests.clients.gcore.box_api.models.v1_inference_api_key_secret_response import V1InferenceAPIKeySecretResponse as V1InferenceAPIKeySecretResponse
from si_tests.clients.gcore.box_api.models.v1_inference_log import V1InferenceLog as V1InferenceLog
from si_tests.clients.gcore.box_api.models.v1_inference_logs_response import V1InferenceLogsResponse as V1InferenceLogsResponse
from si_tests.clients.gcore.box_api.models.v1_inference_response import V1InferenceResponse as V1InferenceResponse
from si_tests.clients.gcore.box_api.models.v1_ingress_opts import V1IngressOpts as V1IngressOpts
from si_tests.clients.gcore.box_api.models.v1_list_api_keys_response import V1ListApiKeysResponse as V1ListApiKeysResponse
from si_tests.clients.gcore.box_api.models.v1_list_flavor_response import V1ListFlavorResponse as V1ListFlavorResponse
from si_tests.clients.gcore.box_api.models.v1_list_group_response import V1ListGroupResponse as V1ListGroupResponse
from si_tests.clients.gcore.box_api.models.v1_list_images_response import V1ListImagesResponse as V1ListImagesResponse
from si_tests.clients.gcore.box_api.models.v1_list_inference_response import V1ListInferenceResponse as V1ListInferenceResponse
from si_tests.clients.gcore.box_api.models.v1_list_instance_response import V1ListInstanceResponse as V1ListInstanceResponse
from si_tests.clients.gcore.box_api.models.v1_list_namespace_response import V1ListNamespaceResponse as V1ListNamespaceResponse
from si_tests.clients.gcore.box_api.models.v1_list_node_group_response import V1ListNodeGroupResponse as V1ListNodeGroupResponse
from si_tests.clients.gcore.box_api.models.v1_list_project_response import V1ListProjectResponse as V1ListProjectResponse
from si_tests.clients.gcore.box_api.models.v1_list_pull_secret_response import V1ListPullSecretResponse as V1ListPullSecretResponse
from si_tests.clients.gcore.box_api.models.v1_list_quotas_response import V1ListQuotasResponse as V1ListQuotasResponse
from si_tests.clients.gcore.box_api.models.v1_list_region_response import V1ListRegionResponse as V1ListRegionResponse
from si_tests.clients.gcore.box_api.models.v1_list_registry_response import V1ListRegistryResponse as V1ListRegistryResponse
from si_tests.clients.gcore.box_api.models.v1_list_registry_user_response import V1ListRegistryUserResponse as V1ListRegistryUserResponse
from si_tests.clients.gcore.box_api.models.v1_list_secret_response import V1ListSecretResponse as V1ListSecretResponse
from si_tests.clients.gcore.box_api.models.v1_list_slurm_clusters_response import V1ListSlurmClustersResponse as V1ListSlurmClustersResponse
from si_tests.clients.gcore.box_api.models.v1_list_storage_classes_response import V1ListStorageClassesResponse as V1ListStorageClassesResponse
from si_tests.clients.gcore.box_api.models.v1_list_sub_region_response import V1ListSubRegionResponse as V1ListSubRegionResponse
from si_tests.clients.gcore.box_api.models.v1_list_tls_secret_response import V1ListTlsSecretResponse as V1ListTlsSecretResponse
from si_tests.clients.gcore.box_api.models.v1_list_user_response import V1ListUserResponse as V1ListUserResponse
from si_tests.clients.gcore.box_api.models.v1_list_volumes_response import V1ListVolumesResponse as V1ListVolumesResponse
from si_tests.clients.gcore.box_api.models.v1_logging import V1Logging as V1Logging
from si_tests.clients.gcore.box_api.models.v1_login_response import V1LoginResponse as V1LoginResponse
from si_tests.clients.gcore.box_api.models.v1_login_user_request import V1LoginUserRequest as V1LoginUserRequest
from si_tests.clients.gcore.box_api.models.v1_memory_trigger import V1MemoryTrigger as V1MemoryTrigger
from si_tests.clients.gcore.box_api.models.v1_metrics_query_data import V1MetricsQueryData as V1MetricsQueryData
from si_tests.clients.gcore.box_api.models.v1_metrics_query_response import V1MetricsQueryResponse as V1MetricsQueryResponse
from si_tests.clients.gcore.box_api.models.v1_namespace_response import V1NamespaceResponse as V1NamespaceResponse
from si_tests.clients.gcore.box_api.models.v1_node import V1Node as V1Node
from si_tests.clients.gcore.box_api.models.v1_node_group_response import V1NodeGroupResponse as V1NodeGroupResponse
from si_tests.clients.gcore.box_api.models.v1_node_list_response import V1NodeListResponse as V1NodeListResponse
from si_tests.clients.gcore.box_api.models.v1_nodes_per_region import V1NodesPerRegion as V1NodesPerRegion
from si_tests.clients.gcore.box_api.models.v1_overview_response import V1OverviewResponse as V1OverviewResponse
from si_tests.clients.gcore.box_api.models.v1_pvc_volume_source import V1PVCVolumeSource as V1PVCVolumeSource
from si_tests.clients.gcore.box_api.models.v1_patch_api_key_request import V1PatchApiKeyRequest as V1PatchApiKeyRequest
from si_tests.clients.gcore.box_api.models.v1_patch_slurm_cluster_request import V1PatchSlurmClusterRequest as V1PatchSlurmClusterRequest
from si_tests.clients.gcore.box_api.models.v1_patch_slurm_cluster_worker_config import V1PatchSlurmClusterWorkerConfig as V1PatchSlurmClusterWorkerConfig
from si_tests.clients.gcore.box_api.models.v1_pod import V1Pod as V1Pod
from si_tests.clients.gcore.box_api.models.v1_probe_configuration import V1ProbeConfiguration as V1ProbeConfiguration
from si_tests.clients.gcore.box_api.models.v1_probes import V1Probes as V1Probes
from si_tests.clients.gcore.box_api.models.v1_project_response import V1ProjectResponse as V1ProjectResponse
from si_tests.clients.gcore.box_api.models.v1_pull_secret_response import V1PullSecretResponse as V1PullSecretResponse
from si_tests.clients.gcore.box_api.models.v1_quota_response import V1QuotaResponse as V1QuotaResponse
from si_tests.clients.gcore.box_api.models.v1_refresh_request import V1RefreshRequest as V1RefreshRequest
from si_tests.clients.gcore.box_api.models.v1_region_response import V1RegionResponse as V1RegionResponse
from si_tests.clients.gcore.box_api.models.v1_regional_volume_status import V1RegionalVolumeStatus as V1RegionalVolumeStatus
from si_tests.clients.gcore.box_api.models.v1_registry_image_ref import V1RegistryImageRef as V1RegistryImageRef
from si_tests.clients.gcore.box_api.models.v1_registry_ref import V1RegistryRef as V1RegistryRef
from si_tests.clients.gcore.box_api.models.v1_registry_user_ref import V1RegistryUserRef as V1RegistryUserRef
from si_tests.clients.gcore.box_api.models.v1_registry_user_response import V1RegistryUserResponse as V1RegistryUserResponse
from si_tests.clients.gcore.box_api.models.v1_resource_types_response import V1ResourceTypesResponse as V1ResourceTypesResponse
from si_tests.clients.gcore.box_api.models.v1_scale import V1Scale as V1Scale
from si_tests.clients.gcore.box_api.models.v1_slurm_cluster_login_config import V1SlurmClusterLoginConfig as V1SlurmClusterLoginConfig
from si_tests.clients.gcore.box_api.models.v1_slurm_cluster_response import V1SlurmClusterResponse as V1SlurmClusterResponse
from si_tests.clients.gcore.box_api.models.v1_slurm_cluster_worker_config import V1SlurmClusterWorkerConfig as V1SlurmClusterWorkerConfig
from si_tests.clients.gcore.box_api.models.v1_sqs_trigger import V1SqsTrigger as V1SqsTrigger
from si_tests.clients.gcore.box_api.models.v1_status import V1Status as V1Status
from si_tests.clients.gcore.box_api.models.v1_storage_class_response import V1StorageClassResponse as V1StorageClassResponse
from si_tests.clients.gcore.box_api.models.v1_sub_region_response import V1SubRegionResponse as V1SubRegionResponse
from si_tests.clients.gcore.box_api.models.v1_tcp_socket_probe import V1TcpSocketProbe as V1TcpSocketProbe
from si_tests.clients.gcore.box_api.models.v1_tls_secret_response import V1TlsSecretResponse as V1TlsSecretResponse
from si_tests.clients.gcore.box_api.models.v1_triggers_response import V1TriggersResponse as V1TriggersResponse
from si_tests.clients.gcore.box_api.models.v1_update_api_key_request import V1UpdateApiKeyRequest as V1UpdateApiKeyRequest
from si_tests.clients.gcore.box_api.models.v1_update_group_request import V1UpdateGroupRequest as V1UpdateGroupRequest
from si_tests.clients.gcore.box_api.models.v1_update_inference_request import V1UpdateInferenceRequest as V1UpdateInferenceRequest
from si_tests.clients.gcore.box_api.models.v1_update_instance_request import V1UpdateInstanceRequest as V1UpdateInstanceRequest
from si_tests.clients.gcore.box_api.models.v1_update_instance_response import V1UpdateInstanceResponse as V1UpdateInstanceResponse
from si_tests.clients.gcore.box_api.models.v1_update_node_group_request import V1UpdateNodeGroupRequest as V1UpdateNodeGroupRequest
from si_tests.clients.gcore.box_api.models.v1_update_pull_secret_request import V1UpdatePullSecretRequest as V1UpdatePullSecretRequest
from si_tests.clients.gcore.box_api.models.v1_update_quota_request import V1UpdateQuotaRequest as V1UpdateQuotaRequest
from si_tests.clients.gcore.box_api.models.v1_update_registry_request import V1UpdateRegistryRequest as V1UpdateRegistryRequest
from si_tests.clients.gcore.box_api.models.v1_update_registry_user_request import V1UpdateRegistryUserRequest as V1UpdateRegistryUserRequest
from si_tests.clients.gcore.box_api.models.v1_update_secret_request import V1UpdateSecretRequest as V1UpdateSecretRequest
from si_tests.clients.gcore.box_api.models.v1_update_sub_region_request import V1UpdateSubRegionRequest as V1UpdateSubRegionRequest
from si_tests.clients.gcore.box_api.models.v1_update_tls_secret_request import V1UpdateTlsSecretRequest as V1UpdateTlsSecretRequest
from si_tests.clients.gcore.box_api.models.v1_update_user_request import V1UpdateUserRequest as V1UpdateUserRequest
from si_tests.clients.gcore.box_api.models.v1_update_user_secret_request import V1UpdateUserSecretRequest as V1UpdateUserSecretRequest
from si_tests.clients.gcore.box_api.models.v1_update_volume_request import V1UpdateVolumeRequest as V1UpdateVolumeRequest
from si_tests.clients.gcore.box_api.models.v1_user_response import V1UserResponse as V1UserResponse
from si_tests.clients.gcore.box_api.models.v1_volume_response import V1VolumeResponse as V1VolumeResponse
