import pytest

from si_tests import settings
from si_tests import logger
from si_tests.utils import waiters
from si_tests.managers.kaas_manager import Manager as KaasManager

LOG = logger.logger


@pytest.mark.parametrize("_", ["CLUSTER_NAME={0}"
                               .format(settings.TARGET_CLUSTER)])
@pytest.mark.usefixtures("introspect_distribution_not_changed")
@pytest.mark.usefixtures("collect_downtime_statistics")     # Should be used if ALLOW_WORKLOAD == True
@pytest.mark.usefixtures("store_cluster_description")
@pytest.mark.usefixtures('mcc_loadtest_prometheus')
@pytest.mark.usefixtures('mcc_loadtest_grafana')
@pytest.mark.usefixtures('mcc_loadtest_alerta')
@pytest.mark.usefixtures('mcc_loadtest_kibana')
@pytest.mark.usefixtures('mcc_loadtest_alertmanager')
def test_update_child_stacklight(kaas_manager: KaasManager, _):
    """Update child Stacklight options"""

    cluster_name = settings.TARGET_CLUSTER
    namespace_name = settings.TARGET_NAMESPACE
    ns = kaas_manager.get_namespace(namespace_name)
    child_cluster = ns.get_cluster(cluster_name)

    assert 'stacklight' in child_cluster.get_components(),\
        "Stacklight is not deployed. Nothing to check"

    logging = not child_cluster.logging_enabled()

    LOG.info("\n\nUpdating child cluster {0} Stacklight "
             "logging option to {1}\n\n"
             .format(cluster_name, logging))
    child_pr_spec = child_cluster.data['spec']['providerSpec']
    LOG.info("Current stacklight spec: {}".format(child_pr_spec))

    body = {
        "spec": {
            "providerSpec": {
                "value": {
                    "helmReleases": child_cluster.data.get(
                        "spec").get("providerSpec").get("value").get(
                        "helmReleases")
                }
            }
        }
    }
    lma_body = [x for x in
                body['spec']['providerSpec']['value']['helmReleases']
                if x['name'] == "stacklight"][0]
    if logging:
        lma_body['values'].update(
            {'logging': {'enabled': logging},
             "elasticsearch": {
                "logstashRetentionTime": "30",
                "persistentVolumeClaimSize": "30Gi",
                "retentionTime": {
                    "logstash": "3d",
                    "events": "2w",
                    "notifications": "1m",
                }
            }})
    else:
        lma_body['values'].update(
            {"logging": {"enabled": logging}})
    kaas_manager.api.kaas_clusters.update(
        name=cluster_name, namespace=namespace_name, body=body)
    LOG.info("Check cluster readiness after lma update")
    child_cluster.check.check_cluster_readiness()
    LOG.info("Checking that Cluster providerSpec is updated")
    waiters.wait(lambda: child_cluster.logging_enabled() == logging,
                 timeout=180, interval=10)
    LOG.info("Cluster providerSpec has been updated")

    child_cluster.check.check_actual_expected_pods(timeout=1600)
    child_cluster.check.check_k8s_pods()

    LOG.info("\n*** Child cluster <{0}> Stacklight"
             "has been updated"
             .format(cluster_name))
