import exec_helpers
import pytest
import yaml
import json

from si_tests import settings
from si_tests import logger
import si_tests.utils.templates as templates_utils
from si_tests.utils import utils
from si_tests.utils.utils import Provider

LOG = logger.logger


# Used for vsphere params
def parse_vsphere_params(x):
    return ''.join((x.split("/", 3)[3:]))


def test_kaas_ui(kaas_manager, kaas_ui_prerequisites):
    lb_host = None
    writer_password = kaas_manager.si_config.get_keycloak_user_password('writer')
    machine_folder = facility = network_path = resourse_pool = datastore_path = rhel_path = ""
    eq2_cidr = eq2_dhcpRanges = eq2_gateway = eq2_node_ip = eq2_services_ip = eq2_vlanId = eq2_api = ""

    mgmt_cluster = kaas_manager.get_mgmt_cluster()
    if mgmt_cluster.provider == Provider.baremetal:
        child_data = utils.render_child_data(kaas_manager.si_config, dict())
        # FIXME(alexz): This is wrong hardcode that should be fixed in 2.15+. see story PRODX-11290 PRODX-20493
        lb_host = child_data['child_config'].get('loadbalancer_host', None)
        cloud_provider = 'bm'
    elif mgmt_cluster.provider == Provider.openstack:
        cloud_provider = 'openstack'
    elif mgmt_cluster.provider == Provider.aws:
        cloud_provider = 'aws'
    elif mgmt_cluster.provider == Provider.vsphere:
        cloud_provider = 'vsphere'
    elif mgmt_cluster.provider == Provider.equinixmetal:
        cloud_provider = 'equinix'
        facility = utils.get_available_equinix_metro(
            settings.KAAS_EQUINIX_USER_API_TOKEN,
            settings.KAAS_EQUINIX_MACHINE_TYPE,
            5)
    elif mgmt_cluster.provider == Provider.equinixmetalv2:
        cloud_provider = 'equinixmetalv2'
        cluster_network_config = None
        si_network_config = kaas_manager.si_config.data['network_config']
        for i in si_network_config.keys():
            if settings.KAAS_UI_CHILD_CLUSTER_NAME in i:
                cluster_network_config = si_network_config[i]

        if cluster_network_config:
            facility = utils.get_available_equinix_metro(
                settings.KAAS_EQUINIX_USER_API_TOKEN,
                settings.KAAS_EQUINIX_MACHINE_TYPE,
                5,
                cluster_network_config['metro'])

            child_network_config = cluster_network_config['networkSpec']

            eq2_cidr = child_network_config['cidr']
            eq2_dhcpRanges = child_network_config['dhcpRanges'][0]
            eq2_gateway = child_network_config['gateway']
            eq2_node_ip = child_network_config['includeRanges'][0]
            eq2_services_ip = child_network_config['metallbRanges'][0]
            eq2_vlanId = child_network_config['vlanId']
            eq2_api = child_network_config['loadBalancerHost']
        else:
            raise Exception(
                "The selected scenario does not support creating kaas-ui-child!"
                "Please check SI_SCENARIO in mgmt deploy job"
            )

    elif mgmt_cluster.provider == Provider.azure:
        cloud_provider = 'azure'
    else:
        raise Exception("Unknown provider: {}".format(mgmt_cluster.provider))

    if settings.KAAS_UI_TEST_IMAGE_TAG:
        kaas_version = settings.KAAS_UI_TEST_IMAGE_TAG
    else:
        pod_list = kaas_manager.api.api_core.list_namespaced_pod(
            namespace='kaas',
            label_selector='app.kubernetes.io/instance=kaas-ui').to_dict()[
            'items'][0]

        kaas_version = pod_list['spec']['containers'][0]['image'].split(':')[1]

    new_dir_path = '/nightwatch-tests'

    # playwright
    if settings.KAAS_UI_TEST_TYPE == 'new-e2e':
        postfix_name = "-playwright"
        new_dir_path = '/playwright-tests'
    else:
        postfix_name = "-nightwatch"

    pod_name = settings.KAAS_UI_TEST_POD_NAME + postfix_name
    ns_name = settings.KAAS_UI_E2E_TEST_NS_PREFIX + postfix_name
    pod_namespace = settings.KAAS_UI_TEST_NAMESPACE

    # Delete the pod before test if it is running
    if kaas_manager.api.pods.present(name=pod_name, namespace=pod_namespace):
        LOG.info("Pod '{0}' already exists, deleting".format(pod_name))
        pod = kaas_manager.api.pods.get(name=pod_name, namespace=pod_namespace)
        pod.delete()

    kaas_service = kaas_manager.api.api_core.read_namespaced_service(
        name='kaas-kaas-ui',
        namespace='kaas').to_dict()
    LOG.debug(kaas_service)
    kaas_ui_ip = \
        kaas_service['status']['load_balancer']['ingress'][0]['ip'] or \
        kaas_service['status']['load_balancer']['ingress'][0]['hostname']
    cdn_region = settings.CDN_REGION
    artifacts_region_map = settings.ARTIFACTS_REGION_MAPPING
    ui_image_base = artifacts_region_map[cdn_region]["images_base_url"]
    if mgmt_cluster.provider == Provider.vsphere:
        machine_folder = parse_vsphere_params(settings.KAAS_VSPHERE_MACHINES_FOLDER)
        network_path = parse_vsphere_params(settings.KAAS_VSPHERE_NETWORK_PATH)
        resourse_pool = parse_vsphere_params(settings.KAAS_VSPHERE_RESOURCE_POOL_PATH)
        datastore_path = parse_vsphere_params(settings.KAAS_VSPHERE_DATASTORECLUSTER_PATH)
        rhel_path = parse_vsphere_params(settings.KAAS_VSPHERE_RHEL8_TEMPLATE_PATH)

    options = {
        'KAAS_UI_TEST_IMAGE': ui_image_base + '/' +
        settings.KAAS_UI_TEST_IMAGE + ':' +
        kaas_version,
        'KAAS_UI_TEST_POD_NAME': pod_name,
        'KAAS_UI_E2E_TEST_NS_NAME_PREFIX': ns_name,
        'LOADBALANCER_HOST': lb_host,
        'KAAS_UI_ADDRESS': kaas_ui_ip,
        'KAAS_UI_USERNAME': 'writer',
        'KAAS_UI_PASSWORD': writer_password,
        'CLOUD_PROVIDER': cloud_provider,
        'KAAS_UI_PORT': kaas_service['spec']['ports'][0]['port'],
        'KAAS_UI_TEST_TYPE': settings.KAAS_UI_TEST_TYPE,
        'NEW_PATH': new_dir_path,
        'MACHINES_FOLDER': machine_folder,
        'NETWORK_PATH': network_path,
        'RESOURCE_POOL_PATH': resourse_pool,
        'DATASTORECLUSTER_PATH': datastore_path,
        'RHEL_TEMPLATE_PATH': rhel_path,
        'FACILITY': facility,
        'EQ2_CIDR': eq2_cidr,
        'EQ2_DHCP_RANGES': eq2_dhcpRanges,
        'EQ2_GATEWAY': eq2_gateway,
        'EQ2_NODE_IP': eq2_node_ip,
        'EQ2_SERVICES': eq2_services_ip,
        'EQ2_VLAN_ID': eq2_vlanId,
        'EQ2_API': eq2_api
    }

    templates = templates_utils.render_template(settings.KAAS_UI_TEST_POD_YAML, options)
    LOG.debug(templates)
    json_body = json.dumps(yaml.load(templates, Loader=yaml.SafeLoader))

    pod = kaas_manager.api.pods.create(name=pod_name,
                                       namespace=pod_namespace,
                                       body=json.loads(json_body))
    pod.wait_phase('Running', timeout=3000)
    LOG.info("UI tests uses image {0}"
             .format(pod.data['status']['container_statuses'][0]['image_id']))

    try:
        pod.wait_test(filepath='./test_*', timeout=7200)
    finally:
        exec_helpers.Subprocess().check_call(
            "mkdir -p {}/reports".format(settings.ARTIFACTS_DIR))

        res = pod.exec(
            ['/bin/sh', '-c', 'ls -la {0}/reports'.format(
                settings.KAAS_UI_TEST_REPORTS_DIR)])
        LOG.info("Reports in {0}/reports :\n{1}"
                 .format(settings.KAAS_UI_TEST_REPORTS_DIR, res))

        pod.cp_from_pod(
            source_dir=settings.KAAS_UI_TEST_REPORTS_DIR + '/reports',
            destination=settings.ARTIFACTS_DIR + '/reports'
        )
        pod.cp_from_pod(
            source_dir=settings.KAAS_UI_TEST_REPORTS_DIR + '/screenshots'
        )
        pod.cp_from_pod(
            source_dir=settings.KAAS_UI_TEST_REPORTS_DIR + '/videos'
        )

    exists = pod.check_file_exists('./test_passed')
    if not settings.KEEP_KAAS_UI_TEST_POD_AFTER:
        pod.delete()
    if not exists:
        pytest.fail("Some kaas UI tests failed. "
                    "See detailed report in artifacts")
